/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.customfield;

import com.atlassian.jira.external.beans.ExternalCustomField;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;

public class ExternalCustomFieldConfiguration {
    private final ExternalCustomField customField;
    private final String constrainedProjectId;
    private final List constrainedIssueTypes;
    private final String configurationSchemeId;
    private final String fieldConfigId;

    public ExternalCustomFieldConfiguration(List constrainedIssueTypes, String constrainedProjectId, ExternalCustomField customField, String configurationSchemeId, String fieldConfigId) {
        Assertions.notNull("customField", customField);
        Assertions.notNull("configurationSchemeId", configurationSchemeId);
        Assertions.notNull("fieldConfigId", fieldConfigId);
        if (customField == null) {
            throw new IllegalArgumentException("Can not create an ExternalCustomFieldConfiguration with a null ExternalCustomField.");
        }
        this.constrainedIssueTypes = constrainedIssueTypes != null ? Collections.unmodifiableList(constrainedIssueTypes) : null;
        this.constrainedProjectId = constrainedProjectId;
        this.customField = customField;
        this.configurationSchemeId = configurationSchemeId;
        this.fieldConfigId = fieldConfigId;
    }

    @Deprecated
    public ExternalCustomFieldConfiguration(List constrainedIssueTypes, String constrainedProjectId, ExternalCustomField customField, String configurationSchemeId) {
        this(constrainedIssueTypes, constrainedProjectId, customField, configurationSchemeId, configurationSchemeId);
    }

    public List getConstrainedIssueTypes() {
        return this.constrainedIssueTypes;
    }

    public String getConstrainedProjectId() {
        return this.constrainedProjectId;
    }

    public ExternalCustomField getCustomField() {
        return this.customField;
    }

    public String getConfigurationSchemeId() {
        return this.configurationSchemeId;
    }

    public String getFieldConfigId() {
        return this.fieldConfigId;
    }

    public boolean isConstrainedForIssueType(String issueTypeId) {
        return this.constrainedIssueTypes == null || this.constrainedIssueTypes.contains(issueTypeId);
    }

    public boolean isForAllIssueTypes() {
        return this.constrainedIssueTypes == null;
    }

    public boolean isForAllProjects() {
        return this.constrainedProjectId == null;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalCustomFieldConfiguration that = (ExternalCustomFieldConfiguration)o;
        if (this.constrainedIssueTypes != null ? !this.constrainedIssueTypes.equals(that.constrainedIssueTypes) : that.constrainedIssueTypes != null) {
            return false;
        }
        if (this.constrainedProjectId != null ? !this.constrainedProjectId.equals(that.constrainedProjectId) : that.constrainedProjectId != null) {
            return false;
        }
        return this.customField.equals(that.customField);
    }

    public int hashCode() {
        int result = this.customField.hashCode();
        result = 31 * result + (this.constrainedProjectId != null ? this.constrainedProjectId.hashCode() : 0);
        result = 31 * result + (this.constrainedIssueTypes != null ? this.constrainedIssueTypes.hashCode() : 0);
        return result;
    }
}

