/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.transformer;

import com.atlassian.annotations.Internal;
import com.atlassian.core.util.DateUtils;
import com.atlassian.core.util.InvalidDurationException;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.datetime.LocalDate;
import com.atlassian.jira.issue.customfields.searchers.transformer.CustomFieldInputHelper;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.search.searchers.util.DateSearcherConfig;
import com.atlassian.jira.issue.search.searchers.util.DateSearcherInputHelper;
import com.atlassian.jira.issue.search.searchers.util.RelativeDateSearcherInputHelper;
import com.atlassian.jira.issue.transport.ActionParams;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.util.JqlLocalDateSupport;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.Query;
import com.atlassian.query.clause.AndClause;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.TerminalClauseImpl;
import com.atlassian.query.operator.Operator;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class RelativeDateSearcherInputTransformer
implements SearchInputTransformer {
    private static final Logger log = LoggerFactory.getLogger(RelativeDateSearcherInputTransformer.class);
    private final DateSearcherConfig config;
    private final JqlOperandResolver operandResolver;
    private final JqlLocalDateSupport jqlLocalDateSupport;
    private final CustomFieldInputHelper customFieldInputHelper;
    private final DateTimeFormatterFactory dateTimeFormatterFactory;

    public RelativeDateSearcherInputTransformer(DateSearcherConfig config, JqlOperandResolver operandResolver, JqlLocalDateSupport jqlLocalDateSupport, CustomFieldInputHelper customFieldInputHelper, DateTimeFormatterFactory dateTimeFormatterFactory) {
        this.config = Assertions.notNull("config", config);
        this.operandResolver = Assertions.notNull("operandResolver", operandResolver);
        this.jqlLocalDateSupport = Assertions.notNull("jqlLocalDateSupport", jqlLocalDateSupport);
        this.customFieldInputHelper = Assertions.notNull("customFieldInputHelper", customFieldInputHelper);
        this.dateTimeFormatterFactory = Assertions.notNull("dateTimeFormatterFactory", dateTimeFormatterFactory);
    }

    @Override
    public void populateFromParams(ApplicationUser user, FieldValuesHolder fieldValuesHolder, ActionParams actionParams) {
        Assertions.notNull("fieldValuesHolder", fieldValuesHolder);
        Assertions.notNull("actionParams", actionParams);
        fieldValuesHolder.put(this.config.getBeforeField(), actionParams.getFirstValueForKey(this.config.getBeforeField()));
        fieldValuesHolder.put(this.config.getAfterField(), actionParams.getFirstValueForKey(this.config.getAfterField()));
        fieldValuesHolder.put(this.config.getPreviousField(), actionParams.getFirstValueForKey(this.config.getPreviousField()));
        fieldValuesHolder.put(this.config.getNextField(), actionParams.getFirstValueForKey(this.config.getNextField()));
        fieldValuesHolder.put(this.config.getEqualsField(), actionParams.getFirstValueForKey(this.config.getEqualsField()));
    }

    @Override
    public void validateParams(ApplicationUser user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, I18nHelper i18nHelper, ErrorCollection errors) {
        Assertions.notNull("fieldValuesHolder", fieldValuesHolder);
        Assertions.notNull("i18nHelper", i18nHelper);
        Assertions.notNull("errors", errors);
        this.validateAbsoluteDates(fieldValuesHolder, errors, i18nHelper);
        this.validateRelativeDates(fieldValuesHolder, errors, i18nHelper);
    }

    private void validateAbsoluteDates(FieldValuesHolder fieldValuesHolder, ErrorCollection errors, I18nHelper i18nHelper) {
        String[] dateParamNames = this.config.getAbsoluteFields();
        LocalDate[] dateParamValues = new LocalDate[2];
        int i = 0;
        for (String dateParamName : dateParamNames) {
            String dateString = (String)fieldValuesHolder.get(dateParamName);
            if (StringUtils.isNotEmpty((String)dateString)) {
                DateTimeFormatter dateTimeFormatter = this.dateTimeFormatterFactory.formatter().withStyle(DateTimeStyle.DATE_PICKER);
                try {
                    Date date = dateTimeFormatter.forLoggedInUser().parse(dateString);
                    dateParamValues[i] = this.jqlLocalDateSupport.convertToLocalDate(date.getTime());
                }
                catch (IllegalArgumentException e) {
                    errors.addError(dateParamName, i18nHelper.getText("fields.validation.data.format", dateTimeFormatter.getFormatHint()));
                }
            }
            ++i;
        }
        LocalDate afterDate = dateParamValues[0];
        LocalDate beforeDate = dateParamValues[1];
        if (afterDate != null && beforeDate != null && beforeDate.compareTo(afterDate) < 0) {
            errors.addError(this.config.getAfterField(), i18nHelper.getText("fields.validation.date.absolute.before.after"));
        }
    }

    private void validateRelativeDates(FieldValuesHolder fieldValuesHolder, ErrorCollection errors, I18nHelper i18nHelper) {
        String[] periodParamNames = this.config.getRelativeFields();
        String[] periodParamLabels = new String[]{i18nHelper.getText("navigator.filter.constants.duedate.from"), i18nHelper.getText("navigator.filter.constants.duedate.to")};
        for (int i = 0; i < periodParamNames.length; ++i) {
            String validationKey;
            String periodParam = (String)fieldValuesHolder.get(periodParamNames[i]);
            if (!StringUtils.isNotEmpty((String)periodParam)) continue;
            try {
                DateUtils.getDurationWithNegative((String)periodParam);
                continue;
            }
            catch (InvalidDurationException e) {
                validationKey = fieldValuesHolder.size() > 1 ? "fields.validation.date.period.format" : "fields.validation.date.period.format.single.field";
                errors.addError(periodParamNames[i], i18nHelper.getText(validationKey, periodParamLabels[i]));
                continue;
            }
            catch (NumberFormatException e) {
                validationKey = fieldValuesHolder.size() > 1 ? "fields.validation.date.period.format" : "fields.validation.date.period.format.single.field";
                errors.addError(periodParamNames[i], i18nHelper.getText(validationKey, periodParamLabels[i]));
            }
        }
        String previousDateString = (String)fieldValuesHolder.get(this.config.getPreviousField());
        String nextDateString = (String)fieldValuesHolder.get(this.config.getNextField());
        if (StringUtils.isNotEmpty((String)previousDateString) && StringUtils.isNotEmpty((String)nextDateString)) {
            try {
                long prevDateLong = DateUtils.getDurationWithNegative((String)previousDateString);
                long nextDateLong = DateUtils.getDurationWithNegative((String)nextDateString);
                if (prevDateLong > nextDateLong) {
                    errors.addError(this.config.getPreviousField(), i18nHelper.getText("fields.validation.date.period.from.to"));
                }
            }
            catch (InvalidDurationException invalidDurationException) {
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public void populateFromQuery(ApplicationUser user, FieldValuesHolder fieldValuesHolder, Query query, SearchContext searchContext) {
        DateSearcherInputHelper helper;
        DateSearcherInputHelper.ConvertClauseResult clauseResult;
        Map<String, String> result;
        Assertions.notNull("fieldValuesHolder", fieldValuesHolder);
        Assertions.notNull("query", query);
        if (query.getWhereClause() != null && (result = (clauseResult = (helper = this.createDateSearcherInputHelper()).convertClause(query.getWhereClause(), user, false)).getFields()) != null) {
            fieldValuesHolder.putAll(result);
        }
    }

    private DateSearcherInputHelper createDateSearcherInputHelper() {
        return new RelativeDateSearcherInputHelper(this.config, this.operandResolver, this.jqlLocalDateSupport, this.dateTimeFormatterFactory);
    }

    @Override
    public boolean doRelevantClausesFitFilterForm(ApplicationUser user, Query query, SearchContext searchContext) {
        if (query != null && query.getWhereClause() != null) {
            Clause whereClause = query.getWhereClause();
            DateSearcherInputHelper inputHelper = this.createDateSearcherInputHelper();
            return inputHelper.convertClause(whereClause, user, false).fitsFilterForm();
        }
        return true;
    }

    @Override
    public Clause getSearchClause(ApplicationUser user, FieldValuesHolder fieldValuesHolder) {
        Assertions.notNull("fieldValuesHolder", fieldValuesHolder);
        String clauseName = this.getClauseName(user);
        Clause relativeClause = this.createPeriodClause((String)fieldValuesHolder.get(this.config.getPreviousField()), (String)fieldValuesHolder.get(this.config.getNextField()), clauseName);
        Clause absoluteClause = this.createDateClause((String)fieldValuesHolder.get(this.config.getAfterField()), (String)fieldValuesHolder.get(this.config.getBeforeField()), clauseName);
        Clause equalsClause = this.createDateClause((String)fieldValuesHolder.get(this.config.getEqualsField()), Operator.EQUALS, clauseName);
        Clause compoundAbsoluteClause = RelativeDateSearcherInputTransformer.createCompoundClause(absoluteClause, equalsClause);
        return RelativeDateSearcherInputTransformer.createCompoundClause(relativeClause, compoundAbsoluteClause);
    }

    private Clause createPeriodClause(String lower, String upper, String clauseName) {
        return RelativeDateSearcherInputTransformer.createCompoundClause(this.parsePeriodClause(lower, Operator.GREATER_THAN_EQUALS, clauseName), this.parsePeriodClause(upper, Operator.LESS_THAN_EQUALS, clauseName));
    }

    private Clause parsePeriodClause(String period, Operator operator, String clauseName) {
        if (StringUtils.isBlank((String)period)) {
            return null;
        }
        return new TerminalClauseImpl(clauseName, operator, period);
    }

    private Clause createDateClause(String lower, String upper, String clauseName) {
        Clause fromClause = this.createDateClause(lower, Operator.GREATER_THAN_EQUALS, clauseName);
        Clause toClause = this.createDateClause(upper, Operator.LESS_THAN_EQUALS, clauseName);
        return RelativeDateSearcherInputTransformer.createCompoundClause(fromClause, toClause);
    }

    private Clause createDateClause(String date, Operator operator, String clauseName) {
        if (StringUtils.isNotBlank((String)date)) {
            try {
                Date parse = this.dateTimeFormatterFactory.formatter().withStyle(DateTimeStyle.DATE_PICKER).forLoggedInUser().parse(date);
                LocalDate localDate = this.jqlLocalDateSupport.convertToLocalDate(parse.getTime());
                if (localDate != null) {
                    return new TerminalClauseImpl(clauseName, operator, this.jqlLocalDateSupport.getLocalDateString(localDate));
                }
            }
            catch (IllegalArgumentException e) {
                log.info(String.format("Unable to parse date '%s'.", date));
            }
            return new TerminalClauseImpl(clauseName, operator, date);
        }
        return null;
    }

    private static Clause createCompoundClause(Clause left, Clause right) {
        if (left == null) {
            return right;
        }
        if (right != null) {
            return new AndClause(left, right);
        }
        return left;
    }

    private String getClauseName(ApplicationUser searcher) {
        String fieldName;
        String primaryName = this.config.getClauseNames().getPrimaryName();
        if (primaryName.equalsIgnoreCase(fieldName = this.config.getFieldName())) {
            return fieldName;
        }
        return this.customFieldInputHelper.getUniqueClauseName(searcher, primaryName, fieldName);
    }
}

