/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.template.hook;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenScheme;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenScheme;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.workflow.JiraWorkflow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

@PublicApi
public class ConfigureData {
    private final Project project;
    private final Scheme workflowScheme;
    private final Map<String, JiraWorkflow> createdWorkflows;
    private final FieldConfigScheme issueTypeScheme;
    private final Map<String, IssueType> createdIssueTypes;
    private final IssueTypeScreenScheme issueTypeScreenScheme;
    private final Map<String, FieldScreenScheme> screenSchemes;
    private final Map<String, FieldScreen> screens;
    private final Collection<Resolution> createdResolutions;

    public static ConfigureData create(Project project, Scheme workflowScheme, Map<String, JiraWorkflow> createdWorkflows, FieldConfigScheme issueTypeScheme, Map<String, IssueType> createdIssueTypes, IssueTypeScreenScheme issueTypeScreenScheme, Map<String, FieldScreenScheme> screenSchemes, Map<String, FieldScreen> screens, Collection<Resolution> createdResolutions) {
        return new ConfigureData(project, workflowScheme, createdWorkflows, issueTypeScheme, createdIssueTypes, issueTypeScreenScheme, screenSchemes, screens, createdResolutions);
    }

    public static ConfigureData create(Project project, Scheme workflowScheme, Map<String, JiraWorkflow> createdWorkflows, FieldConfigScheme issueTypeScheme, Map<String, IssueType> createdIssueTypes) {
        return new ConfigureData(project, workflowScheme, createdWorkflows, issueTypeScheme, createdIssueTypes, null, Collections.emptyMap(), Collections.emptyMap(), new ArrayList<Resolution>());
    }

    private ConfigureData(Project project, Scheme workflowScheme, Map<String, JiraWorkflow> createdWorkflows, FieldConfigScheme issueTypeScheme, Map<String, IssueType> createdIssueTypes, IssueTypeScreenScheme issueTypeScreenScheme, Map<String, FieldScreenScheme> screenSchemes, Map<String, FieldScreen> screens, Collection<Resolution> createdResolutions) {
        this.project = project;
        this.workflowScheme = workflowScheme;
        this.createdWorkflows = ConfigureData.toImmutable(createdWorkflows);
        this.issueTypeScheme = issueTypeScheme;
        this.createdIssueTypes = ConfigureData.toImmutable(createdIssueTypes);
        this.issueTypeScreenScheme = issueTypeScreenScheme;
        this.screenSchemes = ConfigureData.toImmutable(screenSchemes);
        this.screens = ConfigureData.toImmutable(screens);
        this.createdResolutions = createdResolutions;
    }

    private static <T> Map<String, T> toImmutable(Map<String, T> map) {
        if (map == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(map);
    }

    public Project project() {
        return this.project;
    }

    public Scheme workflowScheme() {
        return this.workflowScheme;
    }

    public Map<String, JiraWorkflow> createdWorkflows() {
        return this.createdWorkflows;
    }

    public FieldConfigScheme issueTypeScheme() {
        return this.issueTypeScheme;
    }

    public Map<String, IssueType> createdIssueTypes() {
        return this.createdIssueTypes;
    }

    public IssueTypeScreenScheme issueTypeScreenScheme() {
        return this.issueTypeScreenScheme;
    }

    public Map<String, FieldScreenScheme> createdScreenSchemes() {
        return this.screenSchemes;
    }

    public Map<String, FieldScreen> createdScreens() {
        return this.screens;
    }

    public Collection<Resolution> createdResolutions() {
        return this.createdResolutions;
    }
}

