/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Comparator;
import org.apache.commons.collections.ComparatorUtils;
import org.apache.commons.lang.StringUtils;

public enum NaturalOrderStringComparator implements Comparator<String>
{
    CASE_SENSITIVE_ORDER(true),
    CASE_INSENSITIVE_ORDER(false);

    private static final Predicate<Integer> NUMERIC_PREDICATE;
    private final Comparator<String> stringComparator;

    private NaturalOrderStringComparator(boolean caseSensitive) {
        this.stringComparator = caseSensitive ? ComparatorUtils.NATURAL_COMPARATOR : String.CASE_INSENSITIVE_ORDER;
    }

    @Override
    public int compare(String str1, String str2) {
        int str1Marker = 0;
        int str2Marker = 0;
        int str1Length = str1.length();
        int str2Length = str2.length();
        while (str1Marker < str1Length && str2Marker < str2Length) {
            int result;
            String str1Chunk = NaturalOrderStringComparator.getChunk(str1, str1Marker);
            str1Marker += str1Chunk.length();
            String str2Chunk = NaturalOrderStringComparator.getChunk(str2, str2Marker);
            str2Marker += str2Chunk.length();
            if (Character.isDigit(str1Chunk.codePointAt(0)) && Character.isDigit(str2Chunk.codePointAt(0))) {
                result = NaturalOrderStringComparator.compareNumerically(str1Chunk, str2Chunk);
            } else {
                str1Chunk = StringUtils.strip((String)str1Chunk);
                str2Chunk = StringUtils.strip((String)str2Chunk);
                result = this.stringComparator.compare(str1Chunk, str2Chunk);
            }
            if (result == 0) continue;
            return result;
        }
        return str1Length - str2Length;
    }

    private static int compareNumerically(String digits1, String digits2) {
        digits1 = StringUtils.stripStart((String)digits1, (String)"0");
        digits2 = StringUtils.stripStart((String)digits2, (String)"0");
        int str1ChunkLength = digits1.length();
        int result = str1ChunkLength - digits2.length();
        if (result == 0) {
            for (int i = 0; i < str1ChunkLength; ++i) {
                result = digits1.codePointAt(i) - digits2.codePointAt(i);
                if (result == 0) continue;
                return result;
            }
        }
        return result;
    }

    private static String getChunk(String str, int marker) {
        if (Character.isDigit(str.codePointAt(marker))) {
            return NaturalOrderStringComparator.getChunk(str, marker, NUMERIC_PREDICATE);
        }
        return NaturalOrderStringComparator.getChunk(str, marker, (Predicate<Integer>)Predicates.not(NUMERIC_PREDICATE));
    }

    private static String getChunk(String str, int marker, Predicate<Integer> predicate) {
        int endIndex;
        int codePoint;
        int strLength = str.length();
        for (endIndex = marker; endIndex < strLength && predicate.apply((Object)(codePoint = str.codePointAt(endIndex))); endIndex += Character.charCount(codePoint)) {
        }
        return str.substring(marker, endIndex);
    }

    static {
        NUMERIC_PREDICATE = new Predicate<Integer>(){

            public boolean apply(Integer input) {
                return Character.isDigit(input);
            }
        };
    }
}

