/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import java.util.Collection;
import org.ofbiz.core.entity.GenericValue;

public class ProjectActionSupport
extends JiraWebActionSupport {
    private Collection<Project> browsableProjects;
    protected final ProjectManager projectManager;
    private final PermissionManager permissionManager;

    public ProjectActionSupport(ProjectManager projectManager, PermissionManager permissionManager) {
        this.projectManager = projectManager;
        this.permissionManager = permissionManager;
    }

    public ProjectActionSupport() {
        this(ComponentAccessor.getProjectManager(), ComponentAccessor.getPermissionManager());
    }

    public Collection<Project> getBrowsableProjects() {
        if (this.browsableProjects == null) {
            this.browsableProjects = this.permissionManager.getProjects(ProjectPermissions.BROWSE_PROJECTS, this.getLoggedInUser());
        }
        return this.browsableProjects;
    }

    public Long getSelectedProjectId() {
        Project project = this.getSelectedProjectObject();
        return project == null ? null : project.getId();
    }

    public void setSelectedProject(GenericValue project) {
        if (project == null) {
            this.setSelectedProjectId(null);
        } else {
            this.setSelectedProjectId(project.getLong("id"));
        }
    }

    public void setSelectedProject(Project project) {
        if (project == null) {
            this.setSelectedProjectId(null);
        } else {
            this.setSelectedProjectId(project.getId());
        }
    }
}

