/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.workflow.WorkflowUtil;
import com.opensymphony.util.TextUtils;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowFunctionUtils {
    public static final String ORIGINAL_ISSUE_KEY = "originalissueobject";
    private static final Logger log = LoggerFactory.getLogger(WorkflowFunctionUtils.class);

    protected String getCallerName(Map transientVars, Map args) {
        ApplicationUser user = this.getCallerUser(transientVars, args);
        return user != null ? user.getUsername() : null;
    }

    protected ApplicationUser getCaller(Map transientVars, Map args) {
        return this.getCallerUser(transientVars, args);
    }

    protected ApplicationUser getCallerUser(Map transientVars, Map args) {
        return WorkflowFunctionUtils.getUserByKey(WorkflowFunctionUtils.getCallerKey(transientVars, args));
    }

    public static ApplicationUser getCallerUserFromArgs(Map transientVars, Map args) {
        return WorkflowFunctionUtils.getUserByKey(WorkflowFunctionUtils.getCallerKey(transientVars, args));
    }

    public static String getCallerKey(Map transientVars, Map args) {
        String userKey;
        if (args != null && TextUtils.stringSet((String)(userKey = (String)args.get("userKey")))) {
            return userKey;
        }
        return WorkflowUtil.getCallerKey(transientVars);
    }

    public static void populateParamsWithUser(Map<String, Object> params, ApplicationUser user) {
        WorkflowFunctionUtils.populateParamsWithUser(params, user != null ? user.getKey() : null);
    }

    public static ApplicationUser getUserByKey(@Nullable String key) {
        return key != null ? ComponentAccessor.getUserManager().getUserByKey(key) : null;
    }

    public static void populateParamsWithUser(Map<String, Object> params, String userKey) {
        params.put("userKey", userKey);
    }
}

