/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.avatar;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarFormat;
import com.atlassian.jira.avatar.AvatarFormatPolicy;
import com.atlassian.jira.avatar.AvatarImageDataProvider;
import com.atlassian.jira.avatar.Selection;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.icon.IconOwningObjectId;
import com.atlassian.jira.icon.IconType;
import com.atlassian.jira.io.MediaConsumer;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.Consumer;
import com.atlassian.jira.util.dbc.Assertions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

@PublicApi
public interface AvatarManager {
    public static final String AVATAR_IMAGE_FORMAT = "PNG";
    public static final String PNG_CONTENT_TYPE = "image/png";
    public static final String SVG_CONTENT_TYPE = "image/svg+xml";
    public static final AvatarFormat AVATAR_IMAGE_FORMAT_FULL = new AvatarFormat("PNG", "image/png");
    public static final AvatarFormat AVATAR_IMAGE_FORMAT_SVG = new AvatarFormat("SVG", "image/svg+xml");
    public static final String USER_AVATAR_ID_KEY = "user.avatar.id";

    public Avatar getById(Long var1) throws DataAccessException;

    public Avatar getByIdTagged(Long var1) throws DataAccessException;

    public boolean delete(Long var1) throws DataAccessException;

    public boolean delete(Long var1, boolean var2);

    public void update(Avatar var1) throws DataAccessException;

    @Nonnull
    public Avatar create(Avatar var1) throws DataAccessException;

    @Nonnull
    public Avatar create(Avatar var1, InputStream var2, Selection var3) throws DataAccessException, IOException;

    @Nonnull
    public Avatar create(Avatar.Type var1, @Nonnull String var2, @Nonnull AvatarImageDataProvider var3) throws IOException;

    @Nonnull
    public Avatar create(@Nonnull IconType var1, @Nonnull IconOwningObjectId var2, @Nonnull AvatarImageDataProvider var3) throws IOException;

    @Nonnull
    public Avatar create(String var1, String var2, IconType var3, IconOwningObjectId var4, InputStream var5, Selection var6) throws DataAccessException, IOException;

    @Nonnull
    public Avatar create(String var1, String var2, Project var3, InputStream var4, Selection var5) throws DataAccessException, IOException;

    @Nonnull
    public Avatar create(String var1, String var2, ApplicationUser var3, InputStream var4, Selection var5) throws DataAccessException, IOException;

    @Nonnull
    public List<Avatar> getAllSystemAvatars(Avatar.Type var1) throws DataAccessException;

    @Nonnull
    public List<Avatar> getAllSystemAvatars(IconType var1) throws DataAccessException;

    @Nonnull
    @Deprecated
    public List<Avatar> getCustomAvatarsForOwner(Avatar.Type var1, String var2) throws DataAccessException;

    @Nonnull
    public List<Avatar> getCustomAvatarsForOwner(IconType var1, String var2) throws DataAccessException;

    public boolean isAvatarOwner(Avatar var1, String var2);

    @Deprecated
    public void readAvatarData(Avatar var1, ImageSize var2, Consumer<InputStream> var3) throws IOException;

    public void readAvatarData(@Nonnull Avatar var1, @Nonnull Avatar.Size var2, @Nonnull Consumer<InputStream> var3) throws IOException;

    @ExperimentalApi
    public void readAvatarData(@Nonnull Avatar var1, @Nonnull Avatar.Size var2, @Nonnull AvatarFormatPolicy var3, @Nonnull MediaConsumer var4) throws IOException;

    @Nonnull
    public File getAvatarBaseDirectory();

    public Long getDefaultAvatarId(@Nonnull Avatar.Type var1);

    public Long getDefaultAvatarId(@Nonnull IconType var1);

    public Avatar getDefaultAvatar(@Nonnull IconType var1);

    public boolean isValidIconType(@Nonnull IconType var1);

    public Long getAnonymousAvatarId();

    public boolean hasPermissionToView(ApplicationUser var1, Avatar.Type var2, String var3);

    public boolean hasPermissionToView(ApplicationUser var1, ApplicationUser var2);

    public boolean hasPermissionToView(ApplicationUser var1, Project var2);

    public boolean hasPermissionToEdit(ApplicationUser var1, Avatar.Type var2, String var3);

    public boolean hasPermissionToEdit(ApplicationUser var1, ApplicationUser var2);

    public boolean hasPermissionToEdit(ApplicationUser var1, Project var2);

    public boolean userCanView(@Nullable ApplicationUser var1, @Nonnull Avatar var2);

    public boolean userCanDelete(@Nullable ApplicationUser var1, @Nonnull Avatar var2);

    public boolean userCanCreateFor(@Nullable ApplicationUser var1, @Nonnull IconType var2, @Nonnull IconOwningObjectId var3);

    public static enum ImageSize {
        NORMAL(Avatar.Size.NORMAL),
        SMALL(Avatar.Size.SMALL),
        MEDIUM(Avatar.Size.MEDIUM),
        LARGE(Avatar.Size.LARGE),
        XLARGE(Avatar.Size.XLARGE),
        NORMAL_3X(Avatar.Size.NORMAL_3X),
        XXLARGE(Avatar.Size.XXLARGE),
        XXXLARGE(Avatar.Size.XXXLARGE),
        LARGE_3X(Avatar.Size.LARGE_3X),
        RETINA_XXLARGE(Avatar.Size.RETINA_XXLARGE),
        RETINA_XXXLARGE(Avatar.Size.RETINA_XXXLARGE),
        RETINA_XXLARGE_3X(Avatar.Size.RETINA_XXLARGE_3X),
        RETINA_XXXLARGE_3X(Avatar.Size.RETINA_XXXLARGE_3X);

        private final Avatar.Size size;
        private final String filenameFlag;
        private final Selection originSelection;
        private static final ImageSize largest;
        private static final ImageSize defaultSize;

        private ImageSize(Avatar.Size size) {
            this.size = size;
            this.filenameFlag = Assertions.notNull("filenameFlag", size.isDefault ? "" : size.param + "_");
            this.originSelection = new Selection(0, 0, this.getPixels(), this.getPixels());
        }

        public static ImageSize fromSize(Avatar.Size size) {
            for (ImageSize imageSize : ImageSize.values()) {
                if (!imageSize.getSize().equals((Object)size)) continue;
                return imageSize;
            }
            throw new IllegalArgumentException("There should be a matching ImageSize for every Avatar.Size, but there wasn't for '" + (Object)((Object)size) + "'.");
        }

        public Avatar.Size getSize() {
            return this.size;
        }

        public int getPixels() {
            return this.size.getPixels();
        }

        public String getFilenameFlag() {
            return this.filenameFlag;
        }

        public Selection getOriginSelection() {
            return this.originSelection;
        }

        public static ImageSize largest() {
            return largest;
        }

        public static ImageSize defaultSize() {
            return defaultSize;
        }

        public static ImageSize fromString(String text) {
            if (StringUtils.isNotBlank((CharSequence)text)) {
                int size = -1;
                try {
                    size = Integer.parseInt(text);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                for (ImageSize value : ImageSize.values()) {
                    if ((size <= 0 || size != value.getPixels()) && !StringUtils.startsWithIgnoreCase((CharSequence)value.name(), (CharSequence)text) && !StringUtils.startsWithIgnoreCase((CharSequence)value.getFilenameFlag(), (CharSequence)text)) continue;
                    return value;
                }
            }
            return ImageSize.defaultSize();
        }

        public String toString() {
            return this.size.toString();
        }

        static {
            ImageSize maxValue = SMALL;
            ImageSize defaultValue = LARGE;
            for (ImageSize imageSize : ImageSize.values()) {
                if (imageSize.size.isDefault) {
                    defaultValue = imageSize;
                }
                if (imageSize.getPixels() <= maxValue.getPixels()) continue;
                maxValue = imageSize;
            }
            largest = maxValue;
            defaultSize = defaultValue;
        }
    }
}

