/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.customfield;

import com.atlassian.jira.imports.project.customfield.ExternalCustomFieldValue;
import com.atlassian.jira.imports.project.customfield.ProjectCustomFieldImporter;
import com.atlassian.jira.imports.project.mapper.ProjectImportMapper;
import com.atlassian.jira.imports.project.mapper.SimpleProjectImportIdMapper;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;

public class ProjectPickerCustomFieldImporter
implements ProjectCustomFieldImporter {
    @Override
    public MessageSet canMapImportValue(ProjectImportMapper projectImportMapper, ExternalCustomFieldValue customFieldValue, FieldConfig fieldConfig, I18nHelper i18n) {
        String valueAsIntString;
        MessageSetImpl messageSet = new MessageSetImpl();
        SimpleProjectImportIdMapper projectMapper = projectImportMapper.getProjectMapper();
        String mappedId = projectMapper.getMappedId(valueAsIntString = this.getNonDecimalValue(customFieldValue.getValue()));
        if (mappedId == null) {
            String oldProjectName = projectMapper.getDisplayName(valueAsIntString);
            messageSet.addWarningMessage(i18n.getText("admin.error.project.import.project.picker.no.project", oldProjectName));
            messageSet.addWarningMessageInEnglish("The project '" + oldProjectName + "' does not exist in the current JIRA system. This custom field value will not be imported.");
        }
        return messageSet;
    }

    @Override
    public ProjectCustomFieldImporter.MappedCustomFieldValue getMappedImportValue(ProjectImportMapper projectImportMapper, ExternalCustomFieldValue customFieldValue, FieldConfig fieldConfig) {
        SimpleProjectImportIdMapper projectMapper = projectImportMapper.getProjectMapper();
        String valueAsIntString = this.getNonDecimalValue(customFieldValue.getValue());
        String mappedId = projectMapper.getMappedId(valueAsIntString);
        return new ProjectCustomFieldImporter.MappedCustomFieldValue(mappedId);
    }

    private String getNonDecimalValue(String value) {
        if (value != null) {
            return new Long(new Double(value).intValue()).toString();
        }
        return null;
    }
}

