/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment;

import com.atlassian.jira.issue.attachment.TemporaryAttachmentId;
import com.atlassian.mail.MailUtils;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.joda.time.DateTime;

@ParametersAreNonnullByDefault
@Immutable
public class TemporaryWebAttachment {
    private final TemporaryAttachmentId temporaryAttachmentId;
    private final String filename;
    private final String contentType;
    private final String formToken;
    private final DateTime created;
    private final long size;

    public TemporaryWebAttachment(TemporaryAttachmentId temporaryAttachmentId, String filename, String contentType, String formToken, long size, DateTime created) {
        this.temporaryAttachmentId = temporaryAttachmentId;
        this.filename = filename;
        this.contentType = contentType;
        this.formToken = formToken;
        this.size = size;
        this.created = created;
    }

    public TemporaryAttachmentId getTemporaryAttachmentId() {
        return this.temporaryAttachmentId;
    }

    public String getStringId() {
        return this.temporaryAttachmentId.toStringId();
    }

    public String getFilename() {
        return this.filename;
    }

    public String getContentType() {
        return this.getContentType(false);
    }

    public String getContentType(boolean stripParams) {
        if (stripParams) {
            return MailUtils.getContentType((String)this.contentType);
        }
        return this.contentType;
    }

    public String getFormToken() {
        return this.formToken;
    }

    public long getSize() {
        return this.size;
    }

    public DateTime getCreated() {
        return this.created;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.temporaryAttachmentId, this.filename, this.contentType, this.formToken, this.created, this.size});
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TemporaryWebAttachment other = (TemporaryWebAttachment)obj;
        return Objects.equal((Object)this.temporaryAttachmentId, (Object)other.temporaryAttachmentId) && Objects.equal((Object)this.filename, (Object)other.filename) && Objects.equal((Object)this.contentType, (Object)other.contentType) && Objects.equal((Object)this.formToken, (Object)other.formToken) && Objects.equal((Object)this.created, (Object)other.created) && Objects.equal((Object)this.size, (Object)other.size);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("temporaryAttachmentId", (Object)this.temporaryAttachmentId).add("filename", (Object)this.filename).add("contentType", (Object)this.contentType).add("formToken", (Object)this.formToken).add("created", (Object)this.created).add("size", this.size).toString();
    }
}

