/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest.json.beans;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.issue.fields.rest.json.beans.EntityPropertyBean;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

@Internal
public class EntityPropertyBeanHelper {
    public static EntityPropertyBean createFrom(String key, Object jsonJavaObject, String selfLink) {
        return new EntityPropertyBean(key, EntityPropertyBeanHelper.jsonSerialize(jsonJavaObject), selfLink);
    }

    @Nullable
    public static List<EntityPropertyBean> createFrom(List<Map<String, Object>> jacksonEnteredProperties) {
        ArrayList entityPropertyBeans = null;
        if (jacksonEnteredProperties != null) {
            Function mapper = entityPropertyBean -> {
                String key = (String)entityPropertyBean.get("key");
                Object value = entityPropertyBean.get("value");
                return EntityPropertyBeanHelper.createFrom(key, value, null);
            };
            entityPropertyBeans = Lists.newArrayList((Iterable)jacksonEnteredProperties.stream().map(arg_0 -> ((Function)mapper).apply(arg_0)).collect(Collectors.toList()));
        }
        return entityPropertyBeans;
    }

    public static Map<String, JsonNode> propertiesAsMap(List<EntityPropertyBean> properties) {
        HashMap mapOfProperties = Maps.newHashMap();
        if (properties != null) {
            for (EntityPropertyBean propertyBean : properties) {
                try {
                    String jsonString = propertyBean.getValue();
                    JsonNode jsonNode = EntityPropertyBeanHelper.objectMapper().readTree(jsonString);
                    mapOfProperties.put(propertyBean.getKey(), jsonNode);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return mapOfProperties;
    }

    private static String jsonSerialize(Object value) {
        try {
            ObjectMapper objectMapper = EntityPropertyBeanHelper.objectMapper();
            return objectMapper.writeValueAsString(value);
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Unable to JSON serialize the following object '%s'", String.valueOf(value)), e);
        }
    }

    private static ObjectMapper objectMapper() {
        return new ObjectMapper();
    }
}

