/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.jira.datetime.LocalDate;
import com.atlassian.jira.datetime.LocalDateFactory;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.impl.AbstractCustomFieldIndexer;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.Date;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalDateIndexer
extends AbstractCustomFieldIndexer {
    private static final Logger log = LoggerFactory.getLogger(LocalDateIndexer.class);

    public LocalDateIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField) {
        super(fieldVisibilityManager, customField);
    }

    @Override
    public void addDocumentFieldsSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue, true);
    }

    @Override
    public void addDocumentFieldsNotSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue, false);
    }

    private void addDocumentFields(Document doc, Issue issue, boolean searchable) {
        Object value = this.customField.getValue(issue);
        if (value instanceof Date || value == null) {
            Date date = (Date)value;
            try {
                LocalDate localDate = LocalDateFactory.from(date);
                if (date != null) {
                    doc.add((IndexableField)new StoredField(this.getDocumentFieldId(), localDate.getEpochDays()));
                    if (searchable) {
                        doc.add((IndexableField)new LongPoint(this.getDocumentFieldId(), new long[]{localDate.getEpochDays()}));
                    }
                }
                Long sortDateValue = searchable && localDate != null ? Long.valueOf(localDate.getEpochDays()) : Long.valueOf(Long.MAX_VALUE);
                String sortDateFieldName = "sort_" + this.getDocumentFieldId();
                doc.add((IndexableField)new NumericDocValuesField(sortDateFieldName, sortDateValue.longValue()));
            }
            catch (RuntimeException ex) {
                log.warn("Unable to index custom date field '" + this.customField.getName() + "(" + this.customField.getId() + ") with value: " + value);
            }
        }
    }
}

