/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.web.bean.PagerFilter;
import java.util.List;

@PublicApi
public class IssueSearchResultsFactory {
    public static SearchResults<Issue> create(List<Issue> issues, PagerFilter<Issue> pagerFilter) {
        if (issues.size() < pagerFilter.getStart()) {
            pagerFilter.setStart(0);
        }
        return new SearchResults<Issue>(pagerFilter.getCurrentPage(issues), issues.size(), pagerFilter.getMax(), pagerFilter.getStart());
    }

    public static SearchResults<Issue> create(List<Issue> issuesInPage, int totalIssueCount, PagerFilter pagerFilter) {
        if (totalIssueCount < pagerFilter.getStart()) {
            pagerFilter.setStart(0);
        }
        return new SearchResults<Issue>(issuesInPage, totalIssueCount, pagerFilter.getMax(), pagerFilter.getStart());
    }

    public static SearchResults<Issue> create(List<Issue> issuesInPage, int totalIssueCount, int maxIssueCount, int startIndex) {
        if (totalIssueCount < startIndex) {
            startIndex = 0;
        }
        return new SearchResults<Issue>(issuesInPage, totalIssueCount, maxIssueCount, startIndex);
    }

    private IssueSearchResultsFactory() {
    }
}

