/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize;

import com.atlassian.annotations.ExperimentalSpi;
import com.atlassian.jira.user.anonymize.AffectedEntityLink;
import com.atlassian.jira.user.anonymize.AffectedEntityType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

@ExperimentalSpi
public class AffectedEntity {
    private final AffectedEntityType type;
    private final String descriptionKey;
    private final Optional<Long> numberOfOccurrences;
    private final Optional<AffectedEntityLink> link;

    private AffectedEntity(@Nonnull AffectedEntityType type, @Nonnull String descriptionKey, Long numberOfOccurrences, AffectedEntityLink link) {
        this.type = Objects.requireNonNull(type);
        this.descriptionKey = Objects.requireNonNull(descriptionKey);
        this.numberOfOccurrences = Optional.ofNullable(numberOfOccurrences);
        this.link = Optional.ofNullable(link);
    }

    @Nonnull
    public AffectedEntityType getType() {
        return this.type;
    }

    @Nonnull
    public String getDescriptionKey() {
        return this.descriptionKey;
    }

    @Nonnull
    public Optional<Long> getNumberOfOccurrences() {
        return this.numberOfOccurrences;
    }

    @Nonnull
    public Optional<AffectedEntityLink> getLink() {
        return this.link;
    }

    public static Builder newBuilder(@Nonnull AffectedEntityType type) {
        return new Builder(type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AffectedEntity that = (AffectedEntity)o;
        return new EqualsBuilder().append((Object)this.type, (Object)that.type).append((Object)this.descriptionKey, (Object)that.descriptionKey).append(this.numberOfOccurrences, that.numberOfOccurrences).append(this.link, that.link).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.type).append((Object)this.descriptionKey).append(this.numberOfOccurrences).append(this.link).toHashCode();
    }

    public String toString() {
        return "AffectedEntity{type=" + (Object)((Object)this.type) + ", descriptionKey='" + this.descriptionKey + '\'' + ", numberOfOccurrences=" + this.numberOfOccurrences + ", link=" + this.link + '}';
    }

    public static class Builder {
        private AffectedEntityType type;
        private String descriptionKey;
        private Long numberOfOccurrences;
        private AffectedEntityLink link;

        private Builder(@Nonnull AffectedEntityType type) {
            this.type = Objects.requireNonNull(type);
        }

        public Builder descriptionKey(@Nonnull String descriptionKey) {
            this.descriptionKey = Objects.requireNonNull(descriptionKey);
            return this;
        }

        public Builder numberOfOccurrences(Long numberOfOccurrences) {
            this.numberOfOccurrences = numberOfOccurrences;
            return this;
        }

        public Builder link(AffectedEntityLink link) {
            this.link = link;
            return this;
        }

        public AffectedEntity build() {
            return new AffectedEntity(this.type, this.descriptionKey, this.numberOfOccurrences, this.link);
        }
    }
}

