/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UriValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(UriValidator.class);
    private final String encoding;

    public UriValidator(String encoding) {
        this.encoding = encoding;
    }

    @Nullable
    public String getSafeUri(@Nullable String canonicalBaseUri, String uri) {
        if (uri == null) {
            return null;
        }
        return this.buildSafeUri(canonicalBaseUri, uri);
    }

    private String buildSafeUri(String canonicalBaseUri, String uri) {
        URI parsedUri = null;
        try {
            try {
                parsedUri = new URI(this.decode(uri, this.encoding));
            }
            catch (URISyntaxException e) {
                parsedUri = new URI(uri);
            }
            if (parsedUri.isOpaque()) {
                return null;
            }
            String scheme = parsedUri.getScheme();
            if ("http".equalsIgnoreCase(scheme) || "https".equalsIgnoreCase(scheme)) {
                return uri;
            }
            if (this.mergeUris(canonicalBaseUri, uri) != null) {
                return uri;
            }
        }
        catch (URISyntaxException e) {
            LOGGER.debug("Cannot parse URI " + uri);
            return null;
        }
        return null;
    }

    private URI mergeUris(String canonicalBaseUri, String unsafeUri) throws URISyntaxException {
        URI baseUri = canonicalBaseUri.endsWith("/") ? new URI(canonicalBaseUri) : new URI(canonicalBaseUri + "/");
        URI pathUri = unsafeUri.startsWith("/") ? new URI(unsafeUri.substring(1)) : new URI(unsafeUri);
        return baseUri.resolve(pathUri);
    }

    private String decode(String value, String encoding) {
        try {
            return URLDecoder.decode(value, encoding);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.warn("Unable to decode '" + value + "' with encoding '" + encoding + "'. Decoding with UTF8.");
            try {
                return URLDecoder.decode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException ignore) {
                return null;
            }
        }
    }
}

