/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.bean;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.util.AggregateTimeTrackingBean;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraDurationUtils;
import com.atlassian.jira.web.bean.TimeTrackingGraphBean;
import java.util.Locale;

public interface TimeTrackingGraphBeanFactory {
    public TimeTrackingGraphBean createBean(Issue var1, Style var2, I18nHelper var3);

    public TimeTrackingGraphBean createBean(AggregateTimeTrackingBean var1, Style var2, I18nHelper var3);

    public static final class LongStyle
    implements Style {
        @Override
        public String getDuration(Long duration, Locale locale, JiraDurationUtils utils) {
            if (duration != null) {
                return utils.getFormattedDuration(duration, locale);
            }
            return null;
        }

        @Override
        public String getTooltip(Long duration, Locale locale, JiraDurationUtils utils) {
            if (duration != null) {
                return utils.getFormattedDuration(duration, locale);
            }
            return null;
        }
    }

    public static final class ShortStyle
    implements Style {
        @Override
        public String getDuration(Long duration, Locale locale, JiraDurationUtils utils) {
            if (duration != null) {
                return utils.getShortFormattedDuration(duration, locale);
            }
            return null;
        }

        @Override
        public String getTooltip(Long duration, Locale locale, JiraDurationUtils utils) {
            if (duration != null) {
                return utils.getFormattedDuration(duration, locale);
            }
            return null;
        }
    }

    public static interface Style {
        public static final Style SHORT = new ShortStyle();
        public static final Style NORMAL = new LongStyle();

        public String getDuration(Long var1, Locale var2, JiraDurationUtils var3);

        public String getTooltip(Long var1, Locale var2, JiraDurationUtils var3);
    }
}

