/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.avatar;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarFormatPolicy;
import com.atlassian.jira.io.ResourceData;
import java.io.IOException;
import java.util.function.Function;

@Internal
class PngAvatarFormatPolicy
extends AvatarFormatPolicy {
    private final Function<ResourceData, ResourceData> fallback;

    PngAvatarFormatPolicy(Function<ResourceData, ResourceData> fallback) {
        this.fallback = fallback;
    }

    @Override
    ResourceData getData(Avatar avatar, AvatarFormatPolicy.InputStreamSupplier originalData, AvatarFormatPolicy.InputStreamSupplier transcodedData) throws IOException {
        String originalType = avatar.getContentType();
        if ("image/png".equals(originalType)) {
            return new ResourceData(originalData.get(), originalType);
        }
        if (this.canTranscode(avatar)) {
            return new ResourceData(transcodedData.get(), "image/png");
        }
        return this.fallback.apply(new ResourceData(originalData.get(), originalType));
    }

    private boolean canTranscode(Avatar avatar) {
        String type = avatar.getContentType();
        return "image/svg+xml".equals(type) && avatar.isSystemAvatar();
    }
}

