/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.issue.link;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.jira.event.AbstractEvent;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@EventName(value="jql.search.issuelinktype")
public class JqlSearchIssueLinkTypeEvent
extends AbstractEvent {
    private static final Set<String> KNOWN_LINK_TYPES = Sets.newHashSet((Object[])new String[]{"blocks", "is blocked by", "relates to", "duplicates", "is duplicated by", "clones", "is cloned by"});
    private final String operator;
    private final List<String> values;

    public JqlSearchIssueLinkTypeEvent(String operator, List<String> values) {
        this.operator = operator;
        this.values = values.stream().map(v -> KNOWN_LINK_TYPES.contains(v) ? v : "unknown").collect(Collectors.toList());
    }

    public String getOperator() {
        return this.operator;
    }

    public List<String> getValues() {
        return this.values;
    }
}

