/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.mau;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.application.api.ApplicationKey;
import com.atlassian.jira.project.type.ProjectTypeKey;
import java.util.Objects;
import javax.annotation.Nonnull;

@ExperimentalApi
public final class MauApplicationKey {
    private final String key;
    private static final MauApplicationKey FAMILY = new MauApplicationKey("family");
    private static final MauApplicationKey UNKNOWN = new MauApplicationKey("unknown");

    private MauApplicationKey(String key) {
        this.key = key;
    }

    public static MauApplicationKey family() {
        return FAMILY;
    }

    public static MauApplicationKey unknown() {
        return UNKNOWN;
    }

    public static MauApplicationKey forApplication(@Nonnull ApplicationKey applicationKey) {
        return new MauApplicationKey(applicationKey.value());
    }

    public static MauApplicationKey forProjectTypeKey(@Nonnull ProjectTypeKey projectTypeKey) {
        switch (projectTypeKey.getKey()) {
            case "business": {
                return new MauApplicationKey("jira-core");
            }
            case "software": {
                return new MauApplicationKey("jira-software");
            }
            case "service_desk": {
                return new MauApplicationKey("jira-servicedesk");
            }
        }
        return FAMILY;
    }

    public String getKey() {
        return this.key;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MauApplicationKey that = (MauApplicationKey)o;
        return Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }
}

