/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.searchers;

import com.atlassian.annotations.PublicApi;
import com.atlassian.annotations.PublicSpi;
import com.atlassian.jira.JiraDataTypes;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.customfields.NaturallyOrderedCustomFieldSearcher;
import com.atlassian.jira.issue.customfields.SingleValueCustomFieldValueProvider;
import com.atlassian.jira.issue.customfields.searchers.AbstractInitializationCustomFieldSearcher;
import com.atlassian.jira.issue.customfields.searchers.CustomFieldSearcherClauseHandler;
import com.atlassian.jira.issue.customfields.searchers.SimpleCustomFieldSearcherClauseHandler;
import com.atlassian.jira.issue.customfields.searchers.information.CustomFieldSearcherInformation;
import com.atlassian.jira.issue.customfields.searchers.renderer.CustomFieldRenderer;
import com.atlassian.jira.issue.customfields.searchers.transformer.CustomFieldInputHelper;
import com.atlassian.jira.issue.customfields.searchers.transformer.ExactTextCustomFieldSearchInputTransformer;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.IndexingFeatures;
import com.atlassian.jira.issue.index.indexers.impl.ExactTextCustomFieldIndexer;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.searchers.information.SearcherInformation;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.statistics.TextFieldSorter;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.query.ActualValueCustomFieldClauseQueryFactory;
import com.atlassian.jira.jql.util.SimpleIndexValueConverter;
import com.atlassian.jira.jql.validator.ExactTextCustomFieldValidator;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.query.operator.Operator;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.lucene.search.SortField;

@PublicSpi
@PublicApi
public class ExactTextSearcher
extends AbstractInitializationCustomFieldSearcher
implements CustomFieldSearcher,
NaturallyOrderedCustomFieldSearcher {
    private final FieldVisibilityManager fieldVisibilityManager;
    private final JqlOperandResolver jqlOperandResolver;
    private final CustomFieldInputHelper customFieldInputHelper;
    private final IndexingFeatures indexingFeatures;
    private volatile CustomFieldSearcherInformation searcherInformation;
    private volatile SearchInputTransformer searchInputTransformer;
    private volatile SearchRenderer searchRenderer;
    private volatile CustomFieldSearcherClauseHandler customFieldSearcherClauseHandler;

    public ExactTextSearcher(JqlOperandResolver jqlOperandResolver, CustomFieldInputHelper customFieldInputHelper, FieldVisibilityManager fieldVisibilityManager) {
        this(jqlOperandResolver, customFieldInputHelper, fieldVisibilityManager, ComponentAccessor.getComponent(IndexingFeatures.class));
    }

    public ExactTextSearcher(JqlOperandResolver jqlOperandResolver, CustomFieldInputHelper customFieldInputHelper, FieldVisibilityManager fieldVisibilityManager, IndexingFeatures indexingFeatures) {
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.jqlOperandResolver = jqlOperandResolver;
        this.customFieldInputHelper = Assertions.notNull("customFieldInputHelper", customFieldInputHelper);
        this.indexingFeatures = Assertions.notNull("indexingFeatures", indexingFeatures);
    }

    @Override
    public void init(CustomField field) {
        ClauseNames names = field.getClauseNames();
        ExactTextCustomFieldIndexer indexer = new ExactTextCustomFieldIndexer(this.fieldVisibilityManager, field, this.indexingFeatures.isSkipIndexingNullEnabled());
        SimpleIndexValueConverter indexValueConverter = new SimpleIndexValueConverter(false);
        SingleValueCustomFieldValueProvider customFieldValueProvider = new SingleValueCustomFieldValueProvider();
        this.searcherInformation = new CustomFieldSearcherInformation(field.getId(), field.getNameKey(), Collections.singletonList(indexer), new AtomicReference<CustomField>(field));
        this.searchRenderer = new CustomFieldRenderer(names, this.getDescriptor(), field, customFieldValueProvider, this.fieldVisibilityManager);
        this.searchInputTransformer = new ExactTextCustomFieldSearchInputTransformer(field, names, this.searcherInformation.getId(), this.customFieldInputHelper);
        Set<Operator> supportedOperators = OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY;
        this.customFieldSearcherClauseHandler = new SimpleCustomFieldSearcherClauseHandler(new ExactTextCustomFieldValidator(), new ActualValueCustomFieldClauseQueryFactory(field.getId(), this.jqlOperandResolver, indexValueConverter, false), supportedOperators, JiraDataTypes.TEXT);
    }

    @Override
    public SearcherInformation<CustomField> getSearchInformation() {
        if (this.searcherInformation == null) {
            throw new IllegalStateException("Attempt to retrieve SearcherInformation off uninitialised custom field searcher.");
        }
        return this.searcherInformation;
    }

    @Override
    public SearchInputTransformer getSearchInputTransformer() {
        if (this.searchInputTransformer == null) {
            throw new IllegalStateException("Attempt to retrieve searchInputTransformer off uninitialised custom field searcher.");
        }
        return this.searchInputTransformer;
    }

    @Override
    public SearchRenderer getSearchRenderer() {
        if (this.searchRenderer == null) {
            throw new IllegalStateException("Attempt to retrieve searchRenderer off uninitialised custom field searcher.");
        }
        return this.searchRenderer;
    }

    @Override
    public CustomFieldSearcherClauseHandler getCustomFieldSearcherClauseHandler() {
        if (this.customFieldSearcherClauseHandler == null) {
            throw new IllegalStateException("Attempt to retrieve customFieldSearcherClauseHandler off uninitialised custom field searcher.");
        }
        return this.customFieldSearcherClauseHandler;
    }

    public LuceneFieldSorter getSorter(CustomField customField) {
        return new TextFieldSorter(customField.getId());
    }

    @Override
    public String getSortField(CustomField customField) {
        return customField.getId();
    }

    @Override
    public SortField.Type getSortFieldType() {
        return SortField.Type.STRING;
    }
}

