/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.constants;

import com.atlassian.jira.JiraDataType;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.jql.ClauseInformation;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.operator.Operator;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public final class DefaultClauseInformation
implements ClauseInformation {
    private final String indexField;
    private final ClauseNames jqlClauseNames;
    private final String fieldId;
    private final Set<Operator> supportedOperators;
    private final JiraDataType supportedType;

    public DefaultClauseInformation(String indexField, ClauseNames names, String fieldId, Set<Operator> supportedOperators, JiraDataType supportedType) {
        this.supportedType = Assertions.notNull("supportedType", supportedType);
        this.indexField = Assertions.notBlank("indexField", indexField);
        this.jqlClauseNames = Assertions.notNull("names", names);
        this.fieldId = fieldId;
        this.supportedOperators = Assertions.notNull("supportedOperators", supportedOperators);
    }

    public DefaultClauseInformation(String indexField, String jqlClauseName, String fieldId, Set<Operator> supportedOperators, JiraDataType supportedType) {
        this(indexField, new ClauseNames(Assertions.notBlank("jqlClauseNames", jqlClauseName)), fieldId, supportedOperators, supportedType);
    }

    @Override
    public String getIndexField() {
        return this.indexField;
    }

    @Override
    public ClauseNames getJqlClauseNames() {
        return this.jqlClauseNames;
    }

    @Override
    public String getFieldId() {
        return this.fieldId;
    }

    @Override
    public Set<Operator> getSupportedOperators() {
        return this.supportedOperators;
    }

    @Override
    public JiraDataType getDataType() {
        return this.supportedType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultClauseInformation that = (DefaultClauseInformation)o;
        if (this.fieldId != null ? !this.fieldId.equals(that.fieldId) : that.fieldId != null) {
            return false;
        }
        if (!this.indexField.equals(that.indexField)) {
            return false;
        }
        if (!this.jqlClauseNames.equals(that.jqlClauseNames)) {
            return false;
        }
        if (!this.supportedOperators.equals(that.supportedOperators)) {
            return false;
        }
        return this.supportedType.equals(that.supportedType);
    }

    public int hashCode() {
        int result = this.indexField.hashCode();
        result = 31 * result + this.jqlClauseNames.hashCode();
        result = 31 * result + (this.fieldId != null ? this.fieldId.hashCode() : 0);
        result = 31 * result + this.supportedOperators.hashCode();
        result = 31 * result + this.supportedType.hashCode();
        return result;
    }
}

