/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.jql.query.TermQueryFactory;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.List;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;

public final class QueryFactoryResult {
    private static final QueryFactoryResult FALSE_RESULT = new QueryFactoryResult((Query)new BooleanQuery.Builder().build(), false);
    private final Query luceneQuery;
    private final boolean mustNotOccur;

    public static QueryFactoryResult createFalseResult() {
        return FALSE_RESULT;
    }

    static QueryFactoryResult wrapWithVisibilityQuery(String fieldName, QueryFactoryResult result) {
        if (FALSE_RESULT.equals(result)) {
            return result;
        }
        BooleanQuery.Builder finalQuery = new BooleanQuery.Builder();
        QueryFactoryResult.addToBooleanWithMust(result, finalQuery);
        finalQuery.add(TermQueryFactory.visibilityQuery(fieldName), BooleanClause.Occur.FILTER);
        return new QueryFactoryResult((Query)finalQuery.build());
    }

    public static QueryFactoryResult mergeResultsWithShould(List<QueryFactoryResult> results) {
        Assertions.containsNoNulls("results", results);
        BooleanQuery.Builder finalQuery = new BooleanQuery.Builder();
        for (QueryFactoryResult result : results) {
            if (FALSE_RESULT.equals(result)) continue;
            QueryFactoryResult.addToBooleanWithShould(result, finalQuery);
        }
        return new QueryFactoryResult((Query)finalQuery.build());
    }

    private static void addToBooleanWithMust(QueryFactoryResult result, BooleanQuery.Builder booleanQueryBuilder) {
        QueryFactoryResult.addToBooleanWithOccur(result, booleanQueryBuilder, BooleanClause.Occur.MUST);
    }

    private static void addToBooleanWithShould(QueryFactoryResult result, BooleanQuery.Builder booleanQueryBuilder) {
        QueryFactoryResult.addToBooleanWithOccur(result, booleanQueryBuilder, BooleanClause.Occur.SHOULD);
    }

    private static void addToBooleanWithOccur(QueryFactoryResult result, BooleanQuery.Builder booleanQuery, BooleanClause.Occur occur) {
        if (result.mustNotOccur()) {
            booleanQuery.add(result.getLuceneQuery(), BooleanClause.Occur.MUST_NOT);
        } else {
            booleanQuery.add(result.getLuceneQuery(), occur);
        }
    }

    public QueryFactoryResult(Query luceneQuery) {
        this(luceneQuery, false);
    }

    public QueryFactoryResult(Query luceneQuery, boolean mustNotOccur) {
        this.luceneQuery = Assertions.notNull("luceneQuery", luceneQuery);
        this.mustNotOccur = mustNotOccur;
    }

    public Query getLuceneQuery() {
        return this.luceneQuery;
    }

    public boolean mustNotOccur() {
        return this.mustNotOccur;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryFactoryResult that = (QueryFactoryResult)o;
        if (this.mustNotOccur != that.mustNotOccur) {
            return false;
        }
        return this.luceneQuery.equals((Object)that.luceneQuery);
    }

    public int hashCode() {
        int result = this.luceneQuery.hashCode();
        result = 31 * result + (this.mustNotOccur ? 1 : 0);
        return result;
    }

    public String toString() {
        return "QueryFactoryResult{luceneQuery=" + this.luceneQuery + ", mustNotOccur=" + this.mustNotOccur + '}';
    }
}

