/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.permission;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.permission.PermissionHolderType;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.atlassian.fugue.Option;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
@PublicApi
public final class PermissionHolder {
    private final PermissionHolderType type;
    private final String parameter;

    private PermissionHolder(PermissionHolderType type, @Nullable String parameter) {
        this.type = type;
        this.parameter = parameter;
    }

    public static PermissionHolder holder(PermissionHolderType type) {
        return PermissionHolder.holder(type, null);
    }

    public static PermissionHolder holder(PermissionHolderType type, @Nullable String parameter) {
        parameter = Strings.emptyToNull((String)parameter);
        Preconditions.checkArgument((type.requiresParameter() && parameter != null || !type.requiresParameter() && parameter == null ? 1 : 0) != 0, (Object)("Parameter should be set if and only if type requires it. Type was: " + type + ", parameter was: " + parameter));
        return new PermissionHolder(type, parameter);
    }

    public PermissionHolderType getType() {
        return this.type;
    }

    public Option<String> getParameter() {
        return Option.option((Object)this.parameter);
    }

    public String toString() {
        return String.format("(%s, %s)", this.getType(), this.getParameter());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PermissionHolder that = (PermissionHolder)o;
        return Objects.equal((Object)this.type, (Object)that.type) && Objects.equal((Object)this.parameter, (Object)that.parameter);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.type, this.parameter});
    }
}

