/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.collect;

import com.atlassian.jira.util.Predicate;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;

class FilteredIterator<T>
implements Iterator<T> {
    private final Iterator<T> iterator;
    private final Predicate<? super T> predicate;
    private T nextObject;
    private boolean nextObjectSet = false;

    FilteredIterator(@Nonnull Iterator<T> iterator, @Nonnull Predicate<? super T> predicate) {
        this.iterator = Assertions.notNull("iterator", iterator);
        this.predicate = Assertions.notNull("predicate", predicate);
    }

    @Override
    public boolean hasNext() {
        if (this.nextObjectSet) {
            return true;
        }
        return this.setNextObject();
    }

    @Override
    public T next() {
        if (!this.nextObjectSet && !this.setNextObject()) {
            throw new NoSuchElementException();
        }
        this.nextObjectSet = false;
        return this.nextObject;
    }

    @Override
    public void remove() {
        if (this.nextObjectSet) {
            throw new IllegalStateException("remove() cannot be called");
        }
        this.iterator.remove();
    }

    private boolean setNextObject() {
        while (this.iterator.hasNext()) {
            T object = this.iterator.next();
            if (!this.predicate.evaluate(object)) continue;
            this.nextObject = object;
            this.nextObjectSet = true;
            return true;
        }
        return false;
    }
}

