/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.i18n;

import com.atlassian.jira.util.i18n.I18nTranslationMode;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

public class I18nTranslationModeImpl
implements I18nTranslationMode {
    private static final ThreadLocal<Boolean> translationMode = new ThreadLocal();

    public I18nTranslationModeImpl() {
        translationMode.set(false);
    }

    @Override
    public boolean isTranslationMode() {
        Boolean flag = translationMode.get();
        return flag == null ? false : flag;
    }

    @Override
    public void setTranslationsModeOff() {
        translationMode.set(Boolean.FALSE);
    }

    @Override
    public void setTranslationsModeOn(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (!this.sensibleRequest(httpServletRequest)) {
            return;
        }
        translationMode.set(Boolean.TRUE);
        httpServletRequest.setAttribute("X-Atlassian-I18nTranslationMode", (Object)true);
        httpServletResponse.setHeader("X-Atlassian-I18nTranslationMode", "true");
    }

    private boolean sensibleRequest(HttpServletRequest httpServletRequest) {
        String requestedWith = StringUtils.defaultString((String)httpServletRequest.getHeader("X-Requested-With")).toLowerCase();
        if (requestedWith.contains("xmlhttprequest")) {
            return false;
        }
        String urlPath = StringUtils.defaultString((String)httpServletRequest.getRequestURI()).toLowerCase();
        if (urlPath.contains("/rest/") || urlPath.contains("/sr/")) {
            return false;
        }
        String accept = StringUtils.defaultString((String)httpServletRequest.getHeader("Accept")).toLowerCase();
        return !accept.contains("application/json");
    }
}

