/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing;

import com.atlassian.annotations.ExperimentalApi;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;

@Deprecated
@ExperimentalApi
public class AuditingFilter {
    private final String filter;
    private final Long fromTimestamp;
    private final Long toTimestamp;
    private final List<Long> projectIds;
    private final List<String> userIds;
    private final boolean hideExternalDirectories;

    public static Builder builder() {
        return new Builder();
    }

    private AuditingFilter(@Nullable String filter, @Nullable Long fromTimestamp, @Nullable Long toTimestamp, @Nullable List<Long> projectIds, @Nullable List<String> userIds, boolean hideExternalDirectories) {
        this.filter = filter;
        this.fromTimestamp = fromTimestamp;
        this.toTimestamp = toTimestamp;
        this.projectIds = projectIds;
        this.userIds = userIds;
        this.hideExternalDirectories = hideExternalDirectories;
    }

    @Nullable
    public String getFilter() {
        return this.filter;
    }

    @Nullable
    public Long getFromTimestamp() {
        return this.fromTimestamp;
    }

    @Nullable
    public Long getToTimestamp() {
        return this.toTimestamp;
    }

    @Nullable
    public List<Long> getProjectIds() {
        return this.projectIds;
    }

    public Boolean hasProjectIds() {
        return this.projectIds != null && !this.projectIds.isEmpty();
    }

    @Nullable
    public List<String> getUserIds() {
        return this.userIds;
    }

    public Boolean hasUserIds() {
        return this.userIds != null && !this.userIds.isEmpty();
    }

    public boolean isHideExternalDirectories() {
        return this.hideExternalDirectories;
    }

    public static class Builder {
        private String filter;
        private Long fromTimestamp;
        private Long toTimestamp;
        private List<Long> projectIds;
        private List<String> userIds;
        private boolean hideExternalDirectories = false;

        private Builder() {
        }

        public Builder filter(@Nullable String filter) {
            this.filter = filter;
            return this;
        }

        public Builder fromTimestamp(@Nullable Long fromTimestamp) {
            this.fromTimestamp = fromTimestamp;
            return this;
        }

        public Builder toTimestamp(@Nullable Long toTimestamp) {
            this.toTimestamp = toTimestamp;
            return this;
        }

        public Builder projectIds(@Nullable List<Long> projectIds) {
            this.projectIds = projectIds == null ? ImmutableList.of() : ImmutableList.copyOf(projectIds);
            return this;
        }

        public Builder userIds(@Nullable List<String> userIds) {
            this.userIds = userIds == null ? ImmutableList.of() : ImmutableList.copyOf(userIds);
            return this;
        }

        public Builder setHideExternalDirectories(boolean hideExternalDirectories) {
            this.hideExternalDirectories = hideExternalDirectories;
            return this;
        }

        public AuditingFilter build() {
            return new AuditingFilter(this.filter, this.fromTimestamp, this.toTimestamp, this.projectIds, this.userIds, this.hideExternalDirectories);
        }
    }
}

