/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue.fields.screen;

import com.atlassian.annotations.ExperimentalApi;
import com.google.common.base.Preconditions;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

@ExperimentalApi
public class MoveFieldInfo {
    private final Optional<String> afterField;
    private final Optional<MoveFieldPosition> desiredPosition;

    public MoveFieldInfo(Optional<String> afterField, Optional<MoveFieldPosition> desiredPosition) {
        this.afterField = afterField;
        this.desiredPosition = desiredPosition;
    }

    public Optional<String> getAfterField() {
        return this.afterField;
    }

    public Optional<MoveFieldPosition> getDesiredPosition() {
        return this.desiredPosition;
    }

    public static MoveFieldInfo after(String field) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)field), (Object)"Field ID should not be blank");
        return new MoveFieldInfo(Optional.of(field), Optional.empty());
    }

    public static MoveFieldInfo ofPosition(MoveFieldPosition position) {
        return new MoveFieldInfo(Optional.empty(), Optional.ofNullable(position));
    }

    public static enum MoveFieldPosition {
        First,
        Last;

    }
}

