/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.user.search;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.project.Project;
import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UserSearchIssueContext {
    @Nonnull
    private final Project project;
    @Nullable
    private final Issue issue;

    private UserSearchIssueContext(Project project, Issue issue) {
        Preconditions.checkArgument((project != null ? 1 : 0) != 0);
        this.project = project;
        this.issue = issue;
    }

    public static UserSearchIssueContext create(Issue issue) {
        Preconditions.checkArgument((issue.getProjectObject() != null ? 1 : 0) != 0, (String)"Project for issue: %s is null", (Object)issue);
        return new UserSearchIssueContext(issue.getProjectObject(), issue);
    }

    public static UserSearchIssueContext createForNewIssue(Project project) {
        Preconditions.checkArgument((project != null ? 1 : 0) != 0, (Object)"Project cannot be null");
        return new UserSearchIssueContext(project, null);
    }

    public Optional<Long> getIssueId() {
        return Optional.ofNullable(this.issue).map(Issue::getId);
    }

    public Long getProjectId() {
        return this.project.getId();
    }

    public Optional<Issue> getIssue() {
        return Optional.ofNullable(this.issue);
    }

    public Project getProject() {
        return this.project;
    }
}

