/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.issue;

import com.atlassian.annotations.PublicApi;
import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
@PublicApi
public class MentionIssueEvent {
    private final Issue issue;
    private final ApplicationUser fromUser;
    private final Set<ApplicationUser> toUsers;
    private final Set<NotificationRecipient> recipients;
    private final String mentionText;
    private final String fieldId;
    private final Set<NotificationRecipient> currentRecipients;

    @Deprecated
    public MentionIssueEvent(Issue issue, ApplicationUser fromUser, Set<ApplicationUser> toUsers, String mentionText, String fieldId, @Nullable Set<NotificationRecipient> currentRecipients) {
        this(issue, fromUser, toUsers, Collections.emptySet(), mentionText, fieldId, currentRecipients);
    }

    public MentionIssueEvent(Issue issue, ApplicationUser fromUser, Set<ApplicationUser> toUsers, Set<NotificationRecipient> recipients, String mentionText, String fieldId, @Nullable Set<NotificationRecipient> currentRecipients) {
        this.issue = Objects.requireNonNull(issue);
        this.fromUser = Objects.requireNonNull(fromUser);
        this.toUsers = Objects.requireNonNull(toUsers);
        this.recipients = Objects.requireNonNull(recipients);
        this.mentionText = Objects.requireNonNull(mentionText);
        this.fieldId = Objects.requireNonNull(fieldId);
        this.currentRecipients = currentRecipients;
    }

    public Issue getIssue() {
        return this.issue;
    }

    public ApplicationUser getFromUser() {
        return this.fromUser;
    }

    public Set<ApplicationUser> getToUsers() {
        return Collections.unmodifiableSet(this.toUsers);
    }

    public Set<NotificationRecipient> getRecipients() {
        return this.recipients;
    }

    public String getMentionText() {
        return this.mentionText;
    }

    public String getFieldId() {
        return this.fieldId;
    }

    @Deprecated
    @Nullable
    public Set<NotificationRecipient> getCurrentRecipients() {
        return this.currentRecipients;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MentionIssueEvent that = (MentionIssueEvent)o;
        return Objects.equals(this.issue, that.issue) && Objects.equals(this.fromUser, that.fromUser) && Objects.equals(this.toUsers, that.toUsers) && Objects.equals(this.recipients, that.recipients) && Objects.equals(this.mentionText, that.mentionText) && Objects.equals(this.fieldId, that.fieldId) && Objects.equals(this.currentRecipients, that.currentRecipients);
    }

    public int hashCode() {
        return Objects.hash(this.issue, this.fromUser, this.toUsers, this.recipients, this.mentionText, this.fieldId, this.currentRecipients);
    }

    public String toString() {
        return "MentionIssueEvent{issue=" + this.issue + ", fromUser=" + this.fromUser + ", toUsers=" + this.toUsers + ", recipients=" + this.recipients + ", mentionText='" + this.mentionText + '\'' + ", fieldId='" + this.fieldId + '\'' + ", currentRecipients=" + this.currentRecipients + '}';
    }
}

