/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.request;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.index.request.AffectedIndex;
import com.atlassian.jira.index.request.ReindexRequestBase;
import com.atlassian.jira.index.request.ReindexRequestType;
import com.atlassian.jira.index.request.ReindexStatus;
import com.atlassian.jira.index.request.SharedEntityType;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PublicApi
public class ReindexRequest
extends ReindexRequestBase {
    @Nonnull
    private final Set<AffectedIndex> affectedIndexes;
    @Nonnull
    private final Set<SharedEntityType> sharedEntities;
    @Nonnull
    private final List<ReindexRequest> sources;

    protected ReindexRequest(@Nullable Long id, @Nonnull ReindexRequestType type, long requestTime, @Nullable Long startTime, @Nullable Long completionTime, @Nullable String executionNodeId, @Nonnull ReindexStatus status, @Nonnull Set<AffectedIndex> affectedIndexes, @Nonnull Set<SharedEntityType> sharedEntities, @Nonnull List<ReindexRequest> sources) {
        super(id, type, requestTime, startTime, completionTime, executionNodeId, status);
        this.affectedIndexes = ImmutableSet.copyOf(affectedIndexes);
        this.sharedEntities = ImmutableSet.copyOf(sharedEntities);
        this.sources = ImmutableList.copyOf(sources);
    }

    public ReindexRequest(@Nullable Long id, @Nonnull ReindexRequestType type, long requestTime, @Nullable Long startTime, @Nullable Long completionTime, @Nullable String executionNodeId, @Nonnull ReindexStatus status, @Nonnull Set<AffectedIndex> affectedIndexes, @Nonnull Set<SharedEntityType> sharedEntities) {
        this(id, type, requestTime, startTime, completionTime, executionNodeId, status, affectedIndexes, sharedEntities, (List<ReindexRequest>)ImmutableList.of());
    }

    public ReindexRequest(@Nonnull ReindexRequestType type, long requestTime, @Nullable Long startTime, @Nullable Long completionTime, @Nullable String executionNodeId, @Nonnull ReindexStatus status, @Nonnull Set<AffectedIndex> affectedIndexes, @Nonnull Set<SharedEntityType> sharedEntities, @Nonnull List<ReindexRequest> sources) {
        this(null, type, requestTime, startTime, completionTime, executionNodeId, status, affectedIndexes, sharedEntities, (List<ReindexRequest>)ImmutableList.copyOf(sources));
    }

    public ReindexRequest(@Nonnull ReindexRequestBase base, @Nonnull Set<AffectedIndex> affectedIndexes, @Nonnull Set<SharedEntityType> sharedEntities) {
        this(base.getId(), base.getType(), base.getRequestTime(), base.getStartTime(), base.getCompletionTime(), base.getExecutionNodeId(), base.getStatus(), affectedIndexes, sharedEntities, (List<ReindexRequest>)ImmutableList.of());
    }

    @Nonnull
    public ReindexRequest withSources(@Nonnull Collection<ReindexRequest> additionalSourcces) {
        return new ReindexRequest(this.getId(), this.getType(), this.getRequestTime(), this.getStartTime(), this.getCompletionTime(), this.getExecutionNodeId(), this.getStatus(), this.getAffectedIndexes(), this.getSharedEntities(), (List<ReindexRequest>)ImmutableList.builder().addAll(this.getSources()).addAll(additionalSourcces).build());
    }

    @Nonnull
    public Set<AffectedIndex> getAffectedIndexes() {
        return this.affectedIndexes;
    }

    @Nonnull
    public Set<SharedEntityType> getSharedEntities() {
        return this.sharedEntities;
    }

    @Nonnull
    public List<ReindexRequest> getSources() {
        return this.sources;
    }

    @Nonnull
    public Set<Long> getAllRequestIds() {
        LinkedHashSet<Long> requestIds = new LinkedHashSet<Long>();
        this.readRequestIds(requestIds);
        return requestIds;
    }

    private void readRequestIds(@Nonnull Collection<? super Long> requestIds) {
        if (this.getId() != null) {
            requestIds.add(this.getId());
        }
        for (ReindexRequest source : this.sources) {
            source.readRequestIds(requestIds);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReindexRequest)) {
            return false;
        }
        ReindexRequest that = (ReindexRequest)o;
        if (!Objects.equal((Object)this.getId(), (Object)that.getId())) {
            return false;
        }
        if (!Objects.equal((Object)((Object)this.getType()), (Object)((Object)that.getType()))) {
            return false;
        }
        if (!Objects.equal((Object)this.getRequestTime(), (Object)that.getRequestTime())) {
            return false;
        }
        if (!Objects.equal((Object)this.getStartTime(), (Object)that.getStartTime())) {
            return false;
        }
        if (!Objects.equal((Object)this.getCompletionTime(), (Object)that.getCompletionTime())) {
            return false;
        }
        if (!Objects.equal((Object)this.getExecutionNodeId(), (Object)that.getExecutionNodeId())) {
            return false;
        }
        if (!Objects.equal((Object)((Object)this.getStatus()), (Object)((Object)that.getStatus()))) {
            return false;
        }
        if (!Objects.equal(this.getAffectedIndexes(), that.getAffectedIndexes())) {
            return false;
        }
        return Objects.equal(this.getSharedEntities(), that.getSharedEntities());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getId(), this.getType(), this.getRequestTime(), this.getStartTime(), this.getCompletionTime(), this.getExecutionNodeId(), this.getStatus(), this.getAffectedIndexes(), this.getSharedEntities()});
    }
}

