/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.analytics;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.annotations.Internal;
import com.atlassian.jira.issue.index.IndexingFeatures;

@EventName(value="jira.indexing.stats")
@Internal
public class JiraIndexingStatsAnalyticsEvent {
    private final boolean cfvValueDrivenIndexingEnabled;
    private final boolean localContextIndexingEnabled;
    private final boolean skipIndexingNullEnabled;
    private final int totalIndexers;
    private final int indexersDeclaringNullHandling;
    private final int indexersSkippingNull;
    private final int customFieldIndexingBatchSize;
    private final int totalCustomFieldTypes;
    private final long customFieldTypesImplementingBatchCustomFieldInfo;

    @Deprecated
    public JiraIndexingStatsAnalyticsEvent(IndexingFeatures indexingFeatures, int totalIndexers, int indexersDeclaringNullHandling, int indexersSkippingNull) {
        throw new UnsupportedOperationException();
    }

    public JiraIndexingStatsAnalyticsEvent(IndexingFeatures indexingFeatures, int totalIndexers, int indexersDeclaringNullHandling, int indexersSkippingNull, int totalCustomFieldTypes, long customFieldTypesImplementingBatchCustomFieldInfo) {
        this.cfvValueDrivenIndexingEnabled = indexingFeatures.isCFValueDrivenIndexingEnabled();
        this.localContextIndexingEnabled = indexingFeatures.isLocalContextIndexingEnabled();
        this.skipIndexingNullEnabled = indexingFeatures.isSkipIndexingNullEnabled();
        this.totalIndexers = totalIndexers;
        this.indexersDeclaringNullHandling = indexersDeclaringNullHandling;
        this.indexersSkippingNull = indexersSkippingNull;
        this.customFieldIndexingBatchSize = indexingFeatures.getCustomFieldIndexingBatchSize();
        this.totalCustomFieldTypes = totalCustomFieldTypes;
        this.customFieldTypesImplementingBatchCustomFieldInfo = customFieldTypesImplementingBatchCustomFieldInfo;
    }

    public boolean isCfvValueDrivenIndexingEnabled() {
        return this.cfvValueDrivenIndexingEnabled;
    }

    public boolean isLocalContextIndexingEnabled() {
        return this.localContextIndexingEnabled;
    }

    public boolean isSkipIndexingNullEnabled() {
        return this.skipIndexingNullEnabled;
    }

    public int getTotalIndexers() {
        return this.totalIndexers;
    }

    public int getIndexersDeclaringNullHandling() {
        return this.indexersDeclaringNullHandling;
    }

    public int getIndexersSkippingNull() {
        return this.indexersSkippingNull;
    }

    public int getCustomFieldIndexingBatchSize() {
        return this.customFieldIndexingBatchSize;
    }

    public int getTotalCustomFieldTypes() {
        return this.totalCustomFieldTypes;
    }

    public long getCustomFieldTypesImplementingBatchCustomFieldInfo() {
        return this.customFieldTypesImplementingBatchCustomFieldInfo;
    }
}

