/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.impl.AbstractCustomFieldIndexer;
import com.atlassian.jira.issue.index.indexers.impl.FieldIndexerUtil;
import com.atlassian.jira.issue.index.indexers.phrase.PhraseQuerySupportField;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.FieldVisibilityManager;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;

public class SortableTextCustomFieldIndexer
extends AbstractCustomFieldIndexer {
    private final String sortFieldPrefix;
    private final boolean skipIndexingNull;

    public SortableTextCustomFieldIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField, String sortFieldPrefix, boolean skipIndexingNull) {
        super(fieldVisibilityManager, Assertions.notNull("field", customField));
        this.sortFieldPrefix = Assertions.notBlank("sortFieldPrefix", sortFieldPrefix);
        this.skipIndexingNull = skipIndexingNull;
    }

    public SortableTextCustomFieldIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField, String sortFieldPrefix) {
        this(fieldVisibilityManager, customField, sortFieldPrefix, false);
    }

    @Override
    public void addDocumentFieldsSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue, true);
    }

    @Override
    public void addDocumentFieldsNotSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue, false);
    }

    @Override
    public Boolean skipsIndexingNull() {
        return this.skipIndexingNull;
    }

    private void addDocumentFields(Document doc, Issue issue, boolean searchable) {
        String value = (String)this.customField.getValue(issue);
        String valueForSorting = FieldIndexerUtil.getValueForSorting(value);
        if (value != null) {
            if (searchable) {
                doc.add((IndexableField)new TextField(this.getDocumentFieldId(), value, Field.Store.YES));
                doc.add((IndexableField)new TextField(PhraseQuerySupportField.forIndexField(this.getDocumentFieldId()), value, Field.Store.YES));
                doc.add((IndexableField)new SortedDocValuesField(this.sortFieldPrefix + this.getDocumentFieldId(), new BytesRef((CharSequence)valueForSorting)));
            } else {
                doc.add((IndexableField)new StoredField(this.getDocumentFieldId(), value));
                doc.add((IndexableField)new StoredField(PhraseQuerySupportField.forIndexField(this.getDocumentFieldId()), value));
            }
        } else if (searchable && !this.skipIndexingNull) {
            doc.add((IndexableField)new SortedDocValuesField(this.sortFieldPrefix + this.getDocumentFieldId(), new BytesRef((CharSequence)valueForSorting)));
        }
    }
}

