/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.resolver;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.changehistory.ChangeHistoryFieldConstants;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.resolver.UserResolver;
import com.atlassian.jira.jql.resolver.VersionResolver;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ChangeHistoryFieldIdResolver {
    private static final Collection<String> EMPTY_ID = Collections.singleton("-1");
    private final UserResolver userResolver;
    private final VersionResolver versionResolver;
    private final ConstantsManager constantsManager;

    @Deprecated
    public ChangeHistoryFieldIdResolver(ChangeHistoryFieldConstants changeHistoryFieldConstants, VersionResolver versionResolver, ConstantsManager constantsManager) {
        this(changeHistoryFieldConstants, ComponentAccessor.getComponentOfType(UserResolver.class), versionResolver, constantsManager);
    }

    @Deprecated
    public ChangeHistoryFieldIdResolver(ChangeHistoryFieldConstants changeHistoryFieldConstants, UserResolver userResolver, VersionResolver versionResolver, ConstantsManager constantsManager) {
        this.userResolver = userResolver;
        this.versionResolver = versionResolver;
        this.constantsManager = constantsManager;
    }

    public ChangeHistoryFieldIdResolver(UserResolver userResolver, VersionResolver versionResolver, ConstantsManager constantsManager) {
        this.userResolver = userResolver;
        this.versionResolver = versionResolver;
        this.constantsManager = constantsManager;
    }

    public Collection<String> resolveIdsForField(String field, QueryLiteral literal, boolean emptyOperand) {
        String value;
        String string = value = literal.getLongValue() != null ? literal.getLongValue().toString() : literal.getStringValue();
        if (emptyOperand) {
            return value != null ? Collections.singleton(value) : EMPTY_ID;
        }
        if (literal.getLongValue() != null) {
            return ImmutableSet.of((Object)literal.getLongValue().toString());
        }
        if (this.isConstantField(field)) {
            return this.resolveIdsForConstantField(field, literal.getStringValue());
        }
        if (this.isAssigneeOrReporterField(field)) {
            return this.resolveIdsForUserField(value);
        }
        if (this.isVersionField(field)) {
            return this.resolveIdsForVersion(value);
        }
        return Collections.singleton(value);
    }

    private Collection<String> resolveIdsForConstantField(String field, String value) {
        if ("-1".equals(value)) {
            return ImmutableSet.of((Object)value);
        }
        IssueConstant issueConstant = this.constantsManager.getConstantByNameIgnoreCase(field, value);
        if (issueConstant == null) {
            return null;
        }
        return Collections.singletonList(issueConstant.getId());
    }

    private Collection<String> resolveIdsForUserField(String rawValue) {
        return this.userResolver.getIdsFromName(rawValue);
    }

    private Collection<String> resolveIdsForVersion(String rawValue) {
        if ("-1".equals(rawValue)) {
            return ImmutableSet.of((Object)rawValue);
        }
        List<String> idsPerVersion = this.versionResolver.getIdsFromName(rawValue);
        if (idsPerVersion.isEmpty()) {
            return null;
        }
        return Sets.newHashSet(idsPerVersion);
    }

    public boolean isConstantField(String field) {
        return this.constantsManager.getConstantObjects(field) != null;
    }

    public boolean isAssigneeOrReporterField(String field) {
        return SystemSearchConstants.forAssignee().getFieldUrlParameter().equalsIgnoreCase(field) || SystemSearchConstants.forReporter().getFieldUrlParameter().equalsIgnoreCase(field);
    }

    public boolean isVersionField(String field) {
        return "fixversion".equalsIgnoreCase(field);
    }
}

