/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.resolver;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.jql.resolver.IndexInfoResolver;
import com.atlassian.jira.jql.resolver.NameResolver;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.List;

public class UserIndexInfoResolver
implements IndexInfoResolver<ApplicationUser> {
    private final NameResolver<ApplicationUser> userResolver;

    public UserIndexInfoResolver(NameResolver<ApplicationUser> userResolver) {
        this.userResolver = userResolver;
    }

    @Override
    public List<String> getIndexedValues(String rawValue) {
        return this.userResolver.getIdsFromName(Assertions.notNull("rawValue", rawValue));
    }

    @Override
    public List<String> getIndexedValues(Long rawValue) {
        return this.getIndexedValues(Assertions.notNull("rawValue", rawValue).toString());
    }

    @Override
    public String getIndexedValue(ApplicationUser user) {
        return this.getUserKeyService().getKeyForUsername(Assertions.notNull("user", user).getName());
    }

    UserKeyService getUserKeyService() {
        return ComponentAccessor.getComponentOfType(UserKeyService.class);
    }
}

