/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.jira.bc.user.search.UserSearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;

public class UserUtils {
    public static boolean userExists(String username) {
        return UserUtils.getUser(username) != null;
    }

    public static ApplicationUser getUser(String username) {
        return UserUtils.getUserManager().getUserByName(username);
    }

    public static ApplicationUser getUserEvenWhenUnknown(String username) {
        return UserUtils.getUserManager().getUserByNameEvenWhenUnknown(username);
    }

    public static ApplicationUser getUserByEmail(String emailAddress) {
        if ((emailAddress = StringUtils.trimToNull((String)emailAddress)) == null) {
            return null;
        }
        Iterable<ApplicationUser> iterableUsers = UserUtils.getUserSearchService().findUsersByEmail(emailAddress);
        return StreamSupport.stream(iterableUsers.spliterator(), false).findFirst().orElse(null);
    }

    public static List<ApplicationUser> getUsersByEmail(String email) {
        String emailAddress = StringUtils.trimToNull((String)email);
        return Lists.newArrayList(UserUtils.getUserSearchService().findUsersByEmail(emailAddress));
    }

    public static UserManager getUserManager() {
        return ComponentAccessor.getUserManager();
    }

    private static UserSearchService getUserSearchService() {
        return ComponentAccessor.getUserSearchService();
    }
}

