/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.applinks.api.ApplicationLink;

public class BaseUrlSwapper {
    public static String swapBaseUrl(String url, String oldBaseUrl, String newBaseUrl) {
        if (url == null) {
            return null;
        }
        if (!(newBaseUrl = BaseUrlSwapper.fixMismatchedTrailingSlash(oldBaseUrl, newBaseUrl)).equals(oldBaseUrl) && url.startsWith(oldBaseUrl)) {
            return url.replace(oldBaseUrl, newBaseUrl);
        }
        return url;
    }

    private static String fixMismatchedTrailingSlash(String oldBaseUrl, String newBaseUrl) {
        boolean oldBaseUrlHasTrailingSlash = oldBaseUrl.endsWith("/");
        boolean newBaseUrlHasTrailingSlash = newBaseUrl.endsWith("/");
        if (oldBaseUrlHasTrailingSlash && !newBaseUrlHasTrailingSlash) {
            return newBaseUrl + "/";
        }
        if (!oldBaseUrlHasTrailingSlash && newBaseUrlHasTrailingSlash) {
            return newBaseUrl.substring(0, newBaseUrl.length() - 1);
        }
        return newBaseUrl;
    }

    public static String swapRpcUrlToDisplayUrl(String url, ApplicationLink appLink) {
        String rpcUrl = appLink.getRpcUrl().toASCIIString();
        String displayUrl = appLink.getDisplayUrl().toASCIIString();
        return BaseUrlSwapper.swapBaseUrl(url, rpcUrl, displayUrl);
    }
}

