/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.collect;

import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.Transformed;
import com.atlassian.jira.util.collect.UnmodifiableIterator;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import net.jcip.annotations.Immutable;

@Immutable
class DecoratingSet<E>
extends AbstractSet<E> {
    private final Set<E> set;
    private final Function<E, E> transformer;

    DecoratingSet(@Nonnull Set<E> set, @Nonnull Function<E, E> transformer) {
        this.set = Assertions.notNull("set", set);
        this.transformer = Assertions.notNull("transformer", transformer);
    }

    @Override
    public Iterator<E> iterator() {
        return Transformed.iterator(new UnmodifiableIterator<E>(this.set.iterator()), this.transformer);
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public boolean add(E o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }
}

