/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment;

import com.atlassian.jira.issue.attachment.AttachmentKey;
import java.io.InputStream;
import javax.annotation.ParametersAreNonnullByDefault;

public class StoreAttachmentBean {
    private final long id;
    private final Long size;
    private final String originalProjectKey;
    private final String issueKey;
    private final String fileName;
    private final InputStream stream;

    @ParametersAreNonnullByDefault
    private StoreAttachmentBean(long id, Long size, String originalProjectKey, String issueKey, String fileName, InputStream inputStream) {
        this.id = id;
        this.size = size;
        this.originalProjectKey = originalProjectKey;
        this.issueKey = issueKey;
        this.fileName = fileName;
        this.stream = inputStream;
    }

    public Long getSize() {
        return this.size;
    }

    public String getOriginalProjectKey() {
        return this.originalProjectKey;
    }

    public String getIssueKey() {
        return this.issueKey;
    }

    public long getId() {
        return this.id;
    }

    public String getFileName() {
        return this.fileName;
    }

    public AttachmentKey getAttachmentKey() {
        return new AttachmentKey(this.originalProjectKey, this.issueKey, this.id, this.fileName);
    }

    public InputStream getStream() {
        return this.stream;
    }

    @ParametersAreNonnullByDefault
    public static class Builder {
        private long id;
        private Long size;
        private String originalProjectKey;
        private String issueKey;
        private String fileName;
        private final InputStream inputStream;

        public Builder(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        public Builder withId(long id) {
            this.id = id;
            return this;
        }

        public Builder withIssueKey(String issueKey) {
            this.issueKey = issueKey;
            return this;
        }

        public Builder withOriginalProjectKey(String originalProjectKey) {
            this.originalProjectKey = originalProjectKey;
            return this;
        }

        public Builder withSize(long size) {
            this.size = size;
            return this;
        }

        public Builder withFileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public Builder withKey(AttachmentKey destinationKey) {
            this.originalProjectKey = destinationKey.getProjectKey();
            this.issueKey = destinationKey.getIssueKey();
            this.id = destinationKey.getAttachmentId();
            this.fileName = destinationKey.getAttachmentFilename();
            return this;
        }

        public StoreAttachmentBean build() {
            return new StoreAttachmentBean(this.id, this.size, this.originalProjectKey, this.issueKey, this.fileName, this.inputStream);
        }
    }
}

