/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.action.screen;

import com.atlassian.jira.action.screen.AddFieldToScreenUtil;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenTab;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import java.util.LinkedList;

public class AddFieldToScreenUtilImpl
implements AddFieldToScreenUtil {
    int fieldPos = -1;
    private Collection hlFields;
    private FieldScreen fieldScreen;
    private Long fieldScreenId;
    private String[] fieldId;
    private int tabPosition;
    private String fieldPosition;
    private final FieldManager fieldManager;
    private final FieldScreenManager fieldScreenManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    public AddFieldToScreenUtilImpl(JiraAuthenticationContext jiraAuthenticationContext, FieldManager fieldManager, FieldScreenManager fieldScreenManager) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.fieldManager = fieldManager;
        this.fieldScreenManager = fieldScreenManager;
        this.hlFields = new LinkedList();
    }

    @Override
    public ErrorCollection validate() {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (this.getFieldScreen() == null) {
            errorCollection.addErrorMessage(this.jiraAuthenticationContext.getI18nHelper().getText("admin.errors.invalid.field.screen"));
        }
        if (TextUtils.stringSet((String)this.fieldPosition)) {
            try {
                this.fieldPos = Integer.parseInt(this.fieldPosition) - 1;
                if (this.fieldPos < 0 || this.fieldPos > this.getTab().getFieldScreenLayoutItems().size()) {
                    errorCollection.addError("fieldPosition", this.jiraAuthenticationContext.getI18nHelper().getText("admin.errors.invalid.field.position"));
                }
            }
            catch (NumberFormatException e) {
                errorCollection.addError("fieldPosition", this.jiraAuthenticationContext.getI18nHelper().getText("admin.errors.invalid.field.position"));
            }
        } else {
            this.fieldPos = this.getTab().getFieldScreenLayoutItems().size();
        }
        if (this.fieldId == null || this.fieldId.length <= 0) {
            errorCollection.addError("fieldId", this.jiraAuthenticationContext.getI18nHelper().getText("admin.errors.invalid.field"));
        }
        if (!errorCollection.hasAnyErrors()) {
            for (int i = this.fieldId.length - 1; i >= 0; --i) {
                if (this.getFieldScreen().containsField(this.fieldId[i])) {
                    errorCollection.addError("fieldId", this.jiraAuthenticationContext.getI18nHelper().getText("admin.errors.field.with.id.already.exists", this.fieldId[i]));
                    continue;
                }
                String fieldid = this.fieldId[i];
                try {
                    Field field = this.fieldManager.getField(fieldid);
                    if (field != null) continue;
                    errorCollection.addError("fieldId", this.jiraAuthenticationContext.getI18nHelper().getText("admin.errors.invalid.field.id", this.fieldId[i]));
                    continue;
                }
                catch (IllegalArgumentException iae) {
                    errorCollection.addError("fieldId", this.jiraAuthenticationContext.getI18nHelper().getText("admin.errors.invalid.custom.field.id", this.fieldId[i]));
                }
            }
        }
        return errorCollection;
    }

    private FieldScreen getFieldScreen() {
        if (this.fieldScreen == null && this.fieldScreenId != null) {
            this.fieldScreen = this.fieldScreenManager.getFieldScreen(this.fieldScreenId);
        }
        return this.fieldScreen;
    }

    @Override
    public ErrorCollection execute() {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        boolean highlightFields = !this.getTab().getFieldScreenLayoutItems().isEmpty();
        for (int i = this.fieldId.length - 1; i >= 0; --i) {
            this.getTab().addFieldScreenLayoutItem(this.fieldId[i], this.fieldPos);
            if (!highlightFields) continue;
            this.hlFields.add(this.fieldId[i]);
        }
        return errorCollection;
    }

    public FieldScreenTab getTab() {
        if (this.getTabPosition() > -1) {
            return this.getFieldScreen().getTab(this.getTabPosition());
        }
        return null;
    }

    @Override
    public Collection getHlFields() {
        return this.hlFields;
    }

    @Override
    public Long getFieldScreenId() {
        return this.fieldScreenId;
    }

    @Override
    public void setFieldScreenId(Long fieldScreenId) {
        this.fieldScreenId = fieldScreenId;
    }

    @Override
    public String[] getFieldId() {
        return this.fieldId;
    }

    @Override
    public void setFieldId(String[] fieldId) {
        this.fieldId = fieldId;
    }

    @Override
    public int getTabPosition() {
        return this.tabPosition;
    }

    @Override
    public void setTabPosition(int tabPosition) {
        this.tabPosition = tabPosition;
    }

    @Override
    public String getFieldPosition() {
        return this.fieldPosition;
    }

    @Override
    public void setFieldPosition(String fieldPosition) {
        this.fieldPosition = fieldPosition;
    }
}

