/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.application.install;

import com.atlassian.jira.application.install.ApplicationInstallationEnvironment;
import com.atlassian.jira.application.install.ApplicationSource;
import com.atlassian.jira.application.install.BundlesVersionDiscovery;
import com.atlassian.jira.application.install.PluginBundleInstaller;
import com.atlassian.jira.application.install.ReversibleFileOperations;
import com.atlassian.jira.application.install.WhatWasInstalled;
import com.google.common.base.Throwables;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Nonnull
public class ApplicationInstaller {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationInstaller.class);
    private final ApplicationInstallationEnvironment environment;
    private final BundlesVersionDiscovery versionDiscovery;
    private final WhatWasInstalled whatWasInstalled;

    public ApplicationInstaller(ApplicationInstallationEnvironment environment, BundlesVersionDiscovery versionDiscovery, WhatWasInstalled whatWasInstalled) {
        this.environment = environment;
        this.versionDiscovery = versionDiscovery;
        this.whatWasInstalled = whatWasInstalled;
    }

    public void installApplications() {
        File[] applicationsSources = this.environment.getApplicationsSource().listFiles(File::isDirectory);
        if (null == applicationsSources || 0 == applicationsSources.length) {
            LOGGER.trace("No applications source directories - skipping.");
            return;
        }
        PluginBundleInstaller pluginBundleInstaller = new PluginBundleInstaller(this.environment.getApplicationsDestination(), this.versionDiscovery);
        Arrays.stream(applicationsSources).map(ApplicationSource::readFromDir).filter(Objects::nonNull).forEach(applicationSource -> this.installApplicationFiles((ApplicationSource)applicationSource, pluginBundleInstaller));
    }

    private void installApplicationFiles(ApplicationSource applicationSource, PluginBundleInstaller pluginBundleInstaller) {
        try {
            if (this.whatWasInstalled.wasApplicationSourceInstalled(applicationSource)) {
                LOGGER.trace("Application was already installed: " + applicationSource.getApplicationSourceName());
                return;
            }
            try (ReversibleFileOperations reversibleFileOperations = new ReversibleFileOperations();){
                for (File sourceFile : applicationSource.getApplicationBundles()) {
                    pluginBundleInstaller.updatePlugin(sourceFile, reversibleFileOperations);
                }
                this.whatWasInstalled.storeInstalledApplicationSource(applicationSource, reversibleFileOperations);
                reversibleFileOperations.commit();
            }
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
    }
}

