/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.jira.auditing.AffectedLicense;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.ChangedValue;
import com.atlassian.jira.auditing.RecordRequest;
import com.atlassian.jira.auditing.handlers.ChangedValuesBuilder;
import com.atlassian.jira.auditing.handlers.SystemAuditEventHandler;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.license.ConfirmEvaluationLicenseEvent;
import com.atlassian.jira.license.LicenseChangedEvent;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.license.LicensedApplications;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.util.OutlookDate;
import com.atlassian.jira.web.util.OutlookDateManager;
import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.Nonnull;

public class SystemAuditEventHandlerImpl
implements SystemAuditEventHandler {
    private static final String ADMIN_LICENSE_ORGANISATION = "admin.license.organisation";
    private static final String ADMIN_LICENSE_DATE_PURCHASED = "admin.license.date.purchased";
    private static final String ADMIN_LICENSE_TYPE = "admin.license.type";
    private static final String ADMIN_SERVER_ID = "admin.server.id";
    private static final String ADMIN_LICENSE_SEN = "admin.license.sen";
    private final I18nHelper i18nHelper;
    private final OutlookDateManager outlookDateManager;
    private final DateTimeFormatterFactory dateTimeFormatterFactory;

    public SystemAuditEventHandlerImpl(I18nHelper i18nHelper, OutlookDateManager outlookDateManager, DateTimeFormatterFactory dateTimeFormatterFactory) {
        this.i18nHelper = i18nHelper;
        this.outlookDateManager = outlookDateManager;
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
    }

    @Override
    @Nonnull
    public RecordRequest onLicenseChangedEvent(@Nonnull LicenseChangedEvent event) {
        LicenseDetails licenseDetails;
        String eventMessageKey;
        Preconditions.checkNotNull((Object)event, (Object)"event");
        if (event.isLicenseRemoved()) {
            eventMessageKey = "jira.auditing.system.license.removed";
            licenseDetails = (LicenseDetails)event.getPreviousLicenseDetails().getOrNull();
        } else if (event.isLicenseUpdated()) {
            eventMessageKey = "jira.auditing.system.license.updated";
            licenseDetails = (LicenseDetails)event.getNewLicenseDetails().getOrNull();
        } else {
            eventMessageKey = "jira.auditing.system.license.added";
            licenseDetails = (LicenseDetails)event.getNewLicenseDetails().getOrNull();
        }
        Preconditions.checkNotNull((Object)licenseDetails);
        Preconditions.checkNotNull((Object)licenseDetails.getJiraLicense());
        return new RecordRequest(AuditingCategory.SYSTEM, eventMessageKey).forObject((AssociatedItem)new AffectedLicense(licenseDetails)).withChangedValues(this.buildChangedValuesForNewLicense(licenseDetails));
    }

    @Override
    @Nonnull
    public RecordRequest onExtendTrialLicense(@Nonnull ConfirmEvaluationLicenseEvent event) {
        Preconditions.checkNotNull((Object)event, (Object)"event");
        return new RecordRequest(AuditingCategory.SYSTEM, "jira.auditing.system.license.extend.evaluation").forObject((AssociatedItem)new AffectedLicense(event.getUserWhoConfirmed(), true)).withChangedValues(this.buildChangedValuesForEvaluationExtended(event.getExpiredLicenses()));
    }

    private List<ChangedValue> buildChangedValuesForNewLicense(LicenseDetails details) {
        ChangedValuesBuilder changedValues = new ChangedValuesBuilder();
        changedValues.add(ADMIN_LICENSE_ORGANISATION, null, details.getOrganisation());
        changedValues.add(ADMIN_LICENSE_DATE_PURCHASED, null, details.getPurchaseDate(this.getOutlookDate()));
        changedValues.add(ADMIN_LICENSE_TYPE, null, details.getDescription());
        changedValues.add(ADMIN_SERVER_ID, null, details.getJiraLicense().getServerId());
        changedValues.add(ADMIN_LICENSE_SEN, null, details.getSupportEntitlementNumber());
        this.buildUserLimitForNewRoles(details, changedValues);
        this.buildChangedValuesForNewRoles(details, changedValues);
        return changedValues.build();
    }

    private List<ChangedValue> buildChangedValuesForEvaluationExtended(Iterable<LicenseDetails> detailsBag) {
        DateTimeFormatter dateTimeFormatter = this.dateTimeFormatterFactory.formatter().withStyle(DateTimeStyle.ISO_8601_DATE);
        ChangedValuesBuilder changedValues = new ChangedValuesBuilder();
        for (LicenseDetails details : detailsBag) {
            changedValues.add(ADMIN_LICENSE_ORGANISATION, null, details.getOrganisation());
            changedValues.add(ADMIN_LICENSE_DATE_PURCHASED, null, details.getPurchaseDate(this.getOutlookDate()));
            changedValues.add("admin.license.date.expired", null, dateTimeFormatter.format(details.getJiraLicense().getMaintenanceExpiryDate()));
            changedValues.add(ADMIN_LICENSE_TYPE, null, details.getDescription());
            changedValues.add(ADMIN_SERVER_ID, null, details.getJiraLicense().getServerId());
            changedValues.add(ADMIN_LICENSE_SEN, null, details.getSupportEntitlementNumber());
            this.buildUserLimitForNewRoles(details, changedValues);
        }
        return changedValues.build();
    }

    private void buildChangedValuesForNewRoles(LicenseDetails details, ChangedValuesBuilder changedValues) {
        LicensedApplications licensedApplications = details.getLicensedApplications();
        for (ApplicationKey key : licensedApplications.getKeys()) {
            changedValues.add(key.value(), null, String.valueOf(licensedApplications.getUserLimit(key)));
        }
    }

    private void buildUserLimitForNewRoles(LicenseDetails details, ChangedValuesBuilder changedValues) {
        String userLimit = !details.isUnlimitedNumberOfUsers() ? String.valueOf(details.getJiraLicense().getMaximumNumberOfUsers()) : this.i18nHelper.getText("common.words.unlimited");
        changedValues.add("admin.license.user.limit", null, userLimit);
    }

    private OutlookDate getOutlookDate() {
        return this.outlookDateManager.getOutlookDate(this.i18nHelper.getLocale());
    }
}

