/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue.comment;

import com.atlassian.fugue.Effect;
import com.atlassian.fugue.Option;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.bc.issue.comment.property.CommentPropertyService;
import com.atlassian.jira.bc.issue.util.VisibilityValidator;
import com.atlassian.jira.bc.issue.visibility.Visibilities;
import com.atlassian.jira.bc.issue.visibility.Visibility;
import com.atlassian.jira.bc.issue.visibility.VisibilityVisitors;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.entity.property.EntityPropertyService;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.comments.CommentPermissionManager;
import com.atlassian.jira.issue.comments.MutableComment;
import com.atlassian.jira.issue.fields.TextFieldCharacterLengthValidator;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.util.IssueUpdateBean;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.json.JSONObject;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class DefaultCommentService
implements CommentService {
    private static final String ERROR_NO_PERMISSION = "comment.service.error.no.permission";
    private static final String ERROR_NO_PERMISSION_NO_USER = "comment.service.error.no.permission.no.user";
    private static final String ERROR_NO_EDIT_PERMISSION = "comment.service.error.no.edit.permission";
    private static final String ERROR_NO_EDIT_PERMISSION_NO_USER = "comment.service.error.no.edit.permission.no.user";
    private static final String ERROR_NO_COMMENT_VISIBILITY = "comment.service.error.no.comment.visibility";
    private static final String ERROR_NO_COMMENT_VISIBILITY_NO_USER = "comment.service.error.no.comment.visibility.no.user";
    private static final String ERROR_NULL_ISSUE = "comment.service.error.issue.null";
    private static final String ERROR_NULL_BODY = "comment.service.error.body.null";
    private static final String ERROR_NO_COMMENT_FOR_ID = "comment.service.error.no.comment.for.id";
    private static final String ERROR_NO_ID_SPECIFIED = "comment.service.error.no.id.specified";
    public static final String ERROR_NULL_COMMENT_ID = "comment.service.error.update.null.comment.id";
    public static final String ERROR_NULL_COMMENT = "comment.service.error.update.null.comment";
    public static final String ERROR_NULL_COMMENT_DELETE = "comment.service.error.delete.null.comment";
    public static final String ERROR_NULL_COMMENT_ID_DELETE = "comment.service.error.delete.null.comment.id";
    public static final String ERROR_COMMENT_DELETE_ISSUE_UPDATE_FAILED = "comment.service.error.delete.issue.update.failed";
    public static final String ERROR_COMMENT_EDIT_NON_EDITABLE_ISSUE = "comment.service.error.edit.issue.non.editable";
    public static final String ERROR_COMMENT_DELETE_NON_EDITABLE_ISSUE = "comment.service.error.delete.issue.non.editable";
    public static final String ERROR_COMMENT_DELETE_NO_PERMISSION = "comment.service.error.delete.no.permission";
    private static final String COMMENT_I18N_PREFIX = "comment";
    public static final String ERROR_BODY_TOOLONG = "field.error.text.toolong";
    private final CommentManager commentManager;
    private final PermissionManager permissionManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final CommentPermissionManager commentPermissionManager;
    private final IssueUpdater issueUpdater;
    private final IssueManager issueManager;
    private final VisibilityValidator visibilityValidator;
    private final TextFieldCharacterLengthValidator textFieldCharacterLengthValidator;
    private final CommentPropertyService commentPropertyService;

    public DefaultCommentService(CommentManager commentManager, PermissionManager permissionManager, JiraAuthenticationContext jiraAuthenticationContext, CommentPermissionManager commentPermissionManager, IssueUpdater issueUpdater, IssueManager issueManager, VisibilityValidator visibilityValidator, TextFieldCharacterLengthValidator textFieldCharacterLengthValidator) {
        this.commentManager = commentManager;
        this.permissionManager = permissionManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.commentPermissionManager = commentPermissionManager;
        this.issueUpdater = issueUpdater;
        this.issueManager = issueManager;
        this.visibilityValidator = visibilityValidator;
        this.textFieldCharacterLengthValidator = textFieldCharacterLengthValidator;
        this.commentPropertyService = (CommentPropertyService)ComponentAccessor.getComponent(CommentPropertyService.class);
    }

    public void validateCommentUpdate(ApplicationUser user, Long commentId, String body, String groupLevel, Long roleLevelId, ErrorCollection errorCollection) {
        CommentService.CommentParameters commentParameters = CommentService.CommentParameters.builder().body(body).visibility(Visibilities.fromGroupAndRoleId((String)groupLevel, (Long)roleLevelId)).build();
        CommentService.CommentUpdateValidationResult commentValidationResult = this.validateCommentUpdate(user, commentId, commentParameters);
        errorCollection.addErrorCollection(commentValidationResult.getErrorCollection());
    }

    public CommentService.CommentUpdateValidationResult validateCommentUpdate(ApplicationUser user, Long commentId, CommentService.CommentParameters commentParameters) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (commentId == null) {
            errorCollection.addErrorMessage(this.getText(ERROR_NULL_COMMENT_ID));
            return new CommentService.CommentUpdateValidationResult(errorCollection, Option.none(), Option.none());
        }
        MutableComment comment = this.getMutableComment(user, commentId, (ErrorCollection)errorCollection);
        if (comment == null) {
            return new CommentService.CommentUpdateValidationResult(errorCollection, Option.none(), Option.none());
        }
        this.hasPermissionToEdit(user, (Comment)comment, (ErrorCollection)errorCollection);
        if (errorCollection.hasAnyErrors()) {
            return new CommentService.CommentUpdateValidationResult(errorCollection, Option.none(), Option.none());
        }
        CommentService.CommentParameters parameters = CommentService.CommentParameters.builder().body(commentParameters.getBody()).commentProperties(commentParameters.getCommentProperties()).visibility(commentParameters.getVisibility()).created(comment.getCreated()).author(comment.getAuthorApplicationUser()).issue(comment.getIssue()).build();
        if (this.validInput(user, parameters, (ErrorCollection)errorCollection)) {
            comment.setBody(commentParameters.getBody());
            String groupLevel = (String)((Option)commentParameters.getVisibility().accept(VisibilityVisitors.returningGroupLevelVisitor())).getOrNull();
            Long roleLevelId = (Long)((Option)commentParameters.getVisibility().accept(VisibilityVisitors.returningRoleLevelIdVisitor())).getOrNull();
            comment.setGroupLevel(groupLevel);
            comment.setRoleLevelId(roleLevelId);
            comment.setUpdateAuthor(user);
            comment.setUpdated(new Date());
            return new CommentService.CommentUpdateValidationResult(errorCollection, Option.some((Object)parameters.getCommentProperties()), Option.some((Object)comment));
        }
        return new CommentService.CommentUpdateValidationResult(errorCollection, Option.none(), Option.none());
    }

    public void update(ApplicationUser user, MutableComment comment, boolean dispatchEvent, ErrorCollection errorCollection) {
        if (comment == null) {
            errorCollection.addErrorMessage(this.getText(ERROR_NULL_COMMENT));
            return;
        }
        CommentService.CommentParameters parameters = CommentService.CommentParameters.builder().author(comment.getAuthorApplicationUser()).body(comment.getBody()).visibility(Visibilities.fromGroupAndRoleId((String)comment.getGroupLevel(), (Long)comment.getRoleLevelId())).created(comment.getCreated()).build();
        CommentService.CommentUpdateValidationResult commentValidationResult = this.validateCommentUpdate(user, comment.getId(), parameters);
        if (commentValidationResult.isValid()) {
            this.update(user, commentValidationResult, dispatchEvent);
        } else {
            errorCollection.addErrorCollection(commentValidationResult.getErrorCollection());
        }
    }

    public void update(ApplicationUser user, final CommentService.CommentUpdateValidationResult validationResult, final boolean dispatchEvent) {
        validationResult.getComment().foreach((Effect)new Effect<Comment>(){

            public void apply(Comment comment) {
                DefaultCommentService.this.commentManager.update(comment, (Map)validationResult.getCommentProperties().getOrElse((Object)Collections.EMPTY_MAP), dispatchEvent);
            }
        });
    }

    public CommentService.CommentCreateValidationResult validateCommentCreate(ApplicationUser user, @Nonnull CommentService.CommentParameters commentParameters) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (this.hasPermissionToCreate(user, commentParameters.getIssue(), (ErrorCollection)errorCollection) && this.validInput(user, commentParameters, (ErrorCollection)errorCollection)) {
            return new CommentService.CommentCreateValidationResult((ErrorCollection)errorCollection, Option.some((Object)commentParameters));
        }
        return new CommentService.CommentCreateValidationResult((ErrorCollection)errorCollection, Option.none());
    }

    private boolean validInput(ApplicationUser user, CommentService.CommentParameters commentParameters, ErrorCollection errorCollection) {
        return this.isValidAllCommentData(user, commentParameters.getIssue(), commentParameters.getBody(), commentParameters.getVisibility(), errorCollection) && this.validCommentProperty(commentParameters, errorCollection);
    }

    private boolean validCommentProperty(CommentService.CommentParameters commentParameters, ErrorCollection errorCollection) {
        for (Map.Entry property : commentParameters.getCommentProperties().entrySet()) {
            errorCollection.addErrorCollection(this.commentPropertyService.validatePropertyInput(new EntityPropertyService.PropertyInput(((JSONObject)property.getValue()).toString(), (String)property.getKey())));
        }
        return !errorCollection.hasAnyErrors();
    }

    public Comment create(ApplicationUser user, Issue issue, String body, boolean dispatchEvent, ErrorCollection errorCollection) {
        CommentService.CommentCreateValidationResult validationResult = this.validateCommentCreate(user, CommentService.CommentParameters.builder().body(body).issue(issue).build());
        if (validationResult.isValid()) {
            return this.create(user, validationResult, dispatchEvent);
        }
        errorCollection.addErrorCollection(validationResult.getErrorCollection());
        return null;
    }

    public Comment create(ApplicationUser user, Issue issue, String body, String groupLevel, Long roleLevelId, boolean dispatchEvent, ErrorCollection errorCollection) {
        CommentService.CommentParameters commentParameters = CommentService.CommentParameters.builder().body(body).visibility(Visibilities.fromGroupAndRoleId((String)groupLevel, (Long)roleLevelId)).issue(issue).author(user).build();
        CommentService.CommentCreateValidationResult validationResult = this.validateCommentCreate(user, commentParameters);
        if (validationResult.isValid()) {
            return this.create(user, validationResult, dispatchEvent);
        }
        errorCollection.addErrorCollection(validationResult.getErrorCollection());
        return null;
    }

    public Comment create(ApplicationUser user, Issue issue, String body, String groupLevel, Long roleLevelId, Date created, boolean dispatchEvent, ErrorCollection errorCollection) {
        CommentService.CommentParameters commentParameters = CommentService.CommentParameters.builder().body(body).visibility(Visibilities.fromGroupAndRoleId((String)groupLevel, (Long)roleLevelId)).created(created).issue(issue).build();
        CommentService.CommentCreateValidationResult validationResult = this.validateCommentCreate(user, commentParameters);
        if (validationResult.isValid()) {
            return this.create(user, validationResult, dispatchEvent);
        }
        errorCollection.addErrorCollection(validationResult.getErrorCollection());
        return null;
    }

    public Comment create(final ApplicationUser applicationUser, CommentService.CommentCreateValidationResult validationResult, final boolean dispatchEvent) {
        return (Comment)validationResult.getCommentInputParameters().fold((Supplier)new Supplier<Comment>(){

            public Comment get() {
                return null;
            }
        }, (Function)new Function<CommentService.CommentParameters, Comment>(){

            public Comment apply(CommentService.CommentParameters parameters) {
                String groupLevel = (String)((Option)parameters.getVisibility().accept(VisibilityVisitors.returningGroupLevelVisitor())).getOrNull();
                Long roleLevelId = (Long)((Option)parameters.getVisibility().accept(VisibilityVisitors.returningRoleLevelIdVisitor())).getOrNull();
                return DefaultCommentService.this.commentManager.create(parameters.getIssue(), applicationUser, parameters.getBody(), groupLevel, roleLevelId, parameters.getCreated(), parameters.getCommentProperties(), dispatchEvent);
            }
        });
    }

    public List<Comment> getCommentsForUser(ApplicationUser currentUser, Issue issue, ErrorCollection errorCollection) {
        boolean internalError = false;
        List<Object> comments = new ArrayList<Comment>();
        if (issue == null) {
            errorCollection.addErrorMessage(this.getText(ERROR_NULL_ISSUE));
            internalError = true;
        }
        if (!internalError) {
            comments = this.commentManager.getCommentsForUser(issue, currentUser);
        }
        return comments;
    }

    @Nonnull
    public List<Comment> getCommentsForUser(@Nullable ApplicationUser user, @Nonnull Issue issue) {
        Assertions.notNull((String)"issue", (Object)issue);
        return this.commentManager.getCommentsForUser(issue, user);
    }

    @Nonnull
    public List<Comment> getCommentsForUserSince(@Nullable ApplicationUser currentUser, @Nonnull Issue issue, @Nonnull Date since) {
        Assertions.notNull((String)"issue", (Object)issue);
        Assertions.notNull((String)"since", (Object)since);
        return this.commentManager.getCommentsForUserSince(issue, currentUser, since);
    }

    public boolean isValidCommentData(ApplicationUser currentUser, Issue issue, String groupLevel, String roleLevelId, ErrorCollection errorCollection) {
        Visibility visibility = Visibilities.fromGroupAndStrRoleId((String)groupLevel, (String)roleLevelId);
        return this.isValidCommentVisibility(currentUser, issue, visibility, errorCollection);
    }

    public boolean isValidCommentVisibility(ApplicationUser currentUser, Issue issue, Visibility visibility, ErrorCollection errorCollection) {
        return this.visibilityValidator.isValidVisibilityData((JiraServiceContext)new JiraServiceContextImpl(currentUser, errorCollection), COMMENT_I18N_PREFIX, issue, visibility);
    }

    public boolean isValidCommentBody(String body, ErrorCollection errorCollection) {
        return this.isValidCommentBody(body, errorCollection, false);
    }

    public boolean isValidCommentBody(String body, ErrorCollection errorCollection, boolean allowEmpty) {
        boolean valid = true;
        if (!allowEmpty && StringUtils.isBlank((String)body)) {
            valid = false;
            errorCollection.addError(COMMENT_I18N_PREFIX, this.getText(ERROR_NULL_BODY), ErrorCollection.Reason.VALIDATION_FAILED);
        }
        if (this.textFieldCharacterLengthValidator.isTextTooLong(body)) {
            valid = false;
            long maximumNumberOfCharacters = this.textFieldCharacterLengthValidator.getMaximumNumberOfCharacters();
            errorCollection.addError(COMMENT_I18N_PREFIX, this.getText(ERROR_BODY_TOOLONG, String.valueOf(maximumNumberOfCharacters)));
        }
        return valid;
    }

    public boolean isValidAllCommentData(ApplicationUser currentUser, Issue issue, String body, String groupLevel, String roleLevelId, ErrorCollection errorCollection) {
        Visibility visibility = Visibilities.fromGroupAndStrRoleId((String)groupLevel, (String)roleLevelId);
        return this.isValidAllCommentData(currentUser, issue, body, visibility, errorCollection);
    }

    public boolean isValidAllCommentData(ApplicationUser currentUser, Issue issue, String body, Visibility visibility, ErrorCollection errorCollection) {
        boolean validCommentBody = this.isValidCommentBody(body, errorCollection);
        boolean validCommentData = this.isValidCommentVisibility(currentUser, issue, visibility, errorCollection);
        return validCommentBody && validCommentData;
    }

    public boolean isGroupVisiblityEnabled() {
        return this.isGroupVisibilityEnabled();
    }

    public boolean isProjectRoleVisiblityEnabled() {
        return this.isProjectRoleVisibilityEnabled();
    }

    public boolean isGroupVisibilityEnabled() {
        return this.visibilityValidator.isGroupVisibilityEnabled();
    }

    public boolean isProjectRoleVisibilityEnabled() {
        return this.visibilityValidator.isProjectRoleVisibilityEnabled();
    }

    public Comment getCommentById(ApplicationUser user, Long commentId, ErrorCollection errorCollection) {
        return this.getMutableComment(user, commentId, errorCollection);
    }

    public MutableComment getMutableComment(ApplicationUser user, Long commentId, ErrorCollection errorCollection) {
        if (commentId == null) {
            errorCollection.addErrorMessage(this.getText(ERROR_NO_ID_SPECIFIED));
            return null;
        }
        MutableComment comment = this.commentManager.getMutableComment(commentId);
        if (comment == null) {
            errorCollection.addErrorMessage(this.getText(ERROR_NO_COMMENT_FOR_ID, commentId.toString()));
            return null;
        }
        if (this.commentPermissionManager.hasBrowsePermission(user, (Comment)comment)) {
            return comment;
        }
        if (user == null) {
            errorCollection.addErrorMessage(this.getText(ERROR_NO_PERMISSION_NO_USER));
        } else {
            errorCollection.addErrorMessage(this.getText(ERROR_NO_PERMISSION, user.getDisplayName()));
        }
        return null;
    }

    public boolean hasPermissionToDelete(JiraServiceContext jiraServiceContext, Long commentId) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        ApplicationUser user = jiraServiceContext.getLoggedInApplicationUser();
        Comment comment = this.getCommentById(user, commentId, (ErrorCollection)errorCollection);
        if (errorCollection.hasAnyErrors()) {
            jiraServiceContext.getErrorCollection().addErrorCollection((ErrorCollection)errorCollection);
            return false;
        }
        if (!this.hasVisibility(jiraServiceContext, comment)) {
            return false;
        }
        Issue issue = comment.getIssue();
        if (!this.isIssueInEditableWorkflowState(issue)) {
            errorCollection.addErrorMessage(this.getText(ERROR_COMMENT_DELETE_NON_EDITABLE_ISSUE));
            jiraServiceContext.getErrorCollection().addErrorCollection((ErrorCollection)errorCollection);
            return false;
        }
        if (this.userHasCommentDeleteAllPermission(issue, user) || this.userHasCommentDeleteOwnPermission(issue, user) && this.commentManager.isUserCommentAuthor(user, comment)) {
            return true;
        }
        errorCollection.addErrorMessage(this.getText(ERROR_COMMENT_DELETE_NO_PERMISSION, String.valueOf(comment.getId())));
        jiraServiceContext.getErrorCollection().addErrorCollection((ErrorCollection)errorCollection);
        return false;
    }

    protected boolean hasVisibility(JiraServiceContext jiraServiceContext, Comment comment) {
        Issue issue;
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        ApplicationUser user = jiraServiceContext.getLoggedInApplicationUser();
        boolean visible = this.visibilityValidator.isValidVisibilityData((JiraServiceContext)new JiraServiceContextImpl(user, errorCollection), COMMENT_I18N_PREFIX, issue = comment.getIssue(), Visibilities.fromGroupAndRoleId((String)comment.getGroupLevel(), (Long)comment.getRoleLevelId()));
        if (!visible) {
            if (user != null) {
                errorCollection.addErrorMessage(this.getText(ERROR_NO_COMMENT_VISIBILITY, user.getDisplayName()));
            } else {
                errorCollection.addErrorMessage(this.getText(ERROR_NO_COMMENT_VISIBILITY_NO_USER));
            }
        }
        return visible;
    }

    public void delete(JiraServiceContext jiraServiceContext, Comment comment, boolean dispatchEvent) {
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        if (comment == null) {
            errorCollection.addErrorMessage(this.getText(ERROR_NULL_COMMENT_DELETE, null));
            return;
        }
        if (comment.getId() == null) {
            errorCollection.addErrorMessage(this.getText(ERROR_NULL_COMMENT_ID_DELETE));
            return;
        }
        if (this.hasPermissionToDelete(jiraServiceContext, comment.getId())) {
            ChangeItemBean changeItem = this.commentManager.delete(comment);
            this.doUpdateWithChangelog(EventType.ISSUE_COMMENT_DELETED_ID, (List<ChangeItemBean>)ImmutableList.of((Object)changeItem), comment.getIssue(), jiraServiceContext.getLoggedInApplicationUser(), dispatchEvent);
        }
    }

    public boolean hasPermissionToCreate(ApplicationUser user, Issue issue, ErrorCollection errorCollection) {
        boolean hasPerm = this.permissionManager.hasPermission(ProjectPermissions.ADD_COMMENTS, issue, user);
        if (!hasPerm) {
            if (user != null) {
                errorCollection.addErrorMessage(this.getText(ERROR_NO_PERMISSION, user.getDisplayName()), ErrorCollection.Reason.FORBIDDEN);
            } else {
                errorCollection.addErrorMessage(this.getText(ERROR_NO_PERMISSION_NO_USER), ErrorCollection.Reason.FORBIDDEN);
            }
        }
        return hasPerm;
    }

    public boolean hasPermissionToEdit(JiraServiceContext jiraServiceContext, Long commentId) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        ApplicationUser user = jiraServiceContext.getLoggedInApplicationUser();
        Comment comment = this.getCommentById(user, commentId, (ErrorCollection)errorCollection);
        if (errorCollection.hasAnyErrors()) {
            jiraServiceContext.getErrorCollection().addErrorCollection((ErrorCollection)errorCollection);
            return false;
        }
        return this.hasPermissionToEdit(user, comment, jiraServiceContext.getErrorCollection());
    }

    public boolean hasPermissionToEdit(ApplicationUser user, Comment comment, ErrorCollection errorCollection) {
        if (comment == null) {
            errorCollection.addErrorMessage(this.getText(ERROR_NULL_COMMENT));
            return false;
        }
        if (comment.getId() == null) {
            errorCollection.addErrorMessage(this.getText(ERROR_NULL_COMMENT_ID));
            return false;
        }
        if (!this.isIssueInEditableWorkflowState(comment.getIssue())) {
            errorCollection.addErrorMessage(this.getText(ERROR_COMMENT_EDIT_NON_EDITABLE_ISSUE));
            return false;
        }
        if (!this.hasVisibility((JiraServiceContext)new JiraServiceContextImpl(user, errorCollection), comment)) {
            return false;
        }
        boolean hasPerm = this.commentPermissionManager.hasEditPermission(user, comment);
        if (!hasPerm) {
            if (user != null) {
                errorCollection.addErrorMessage(this.getText(ERROR_NO_EDIT_PERMISSION, user.getDisplayName()));
            } else {
                errorCollection.addErrorMessage(this.getText(ERROR_NO_EDIT_PERMISSION_NO_USER));
            }
        }
        return hasPerm;
    }

    protected void doUpdateWithChangelog(Long eventTypeId, List<ChangeItemBean> changeItems, Issue issue, ApplicationUser user, boolean dispatchEvent) {
        IssueUpdateBean issueUpdateBean = new IssueUpdateBean(issue.getGenericValue(), issue.getGenericValue(), eventTypeId, user);
        issueUpdateBean.setChangeItems(changeItems);
        if (dispatchEvent) {
            issueUpdateBean.setDispatchEvent(true);
        }
        this.issueUpdater.doUpdate(issueUpdateBean, false);
    }

    boolean isIssueInEditableWorkflowState(Issue issue) {
        return this.issueManager.isEditable(issue);
    }

    boolean userHasCommentDeleteAllPermission(Issue issue, ApplicationUser user) {
        return this.permissionManager.hasPermission(ProjectPermissions.DELETE_ALL_COMMENTS, issue, user);
    }

    boolean userHasCommentDeleteOwnPermission(Issue issue, ApplicationUser user) {
        return this.permissionManager.hasPermission(ProjectPermissions.DELETE_OWN_COMMENTS, issue, user);
    }

    private String getText(String key) {
        return this.jiraAuthenticationContext.getI18nHelper().getText(key);
    }

    private String getText(String key, String param) {
        return this.jiraAuthenticationContext.getI18nHelper().getText(key, param);
    }
}

