/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue.visibility;

import com.atlassian.fugue.Option;
import com.atlassian.jira.bc.issue.visibility.GroupVisibility;
import com.atlassian.jira.bc.issue.visibility.InvalidVisibility;
import com.atlassian.jira.bc.issue.visibility.PublicVisibility;
import com.atlassian.jira.bc.issue.visibility.RoleVisibility;
import com.atlassian.jira.bc.issue.visibility.VisibilityVisitor;

public class VisibilityVisitors {
    private static final VisibilityVisitor<Option<String>> GROUP_LEVEL_VISITOR = new VisibilityVisitor<Option<String>>(){

        public Option<String> visit(PublicVisibility publicVisibility) {
            return Option.none();
        }

        public Option<String> visit(RoleVisibility roleVisibility) {
            return Option.none();
        }

        public Option<String> visit(GroupVisibility groupVisibility) {
            return Option.some((Object)groupVisibility.getGroupLevel());
        }

        public Option<String> visit(InvalidVisibility invalidVisibility) {
            return Option.none();
        }
    };
    private static final VisibilityVisitor<Option<Long>> ROLE_LEVEL_VISITOR = new VisibilityVisitor<Option<Long>>(){

        public Option<Long> visit(PublicVisibility publicVisibility) {
            return Option.none();
        }

        public Option<Long> visit(RoleVisibility roleVisibility) {
            return Option.some((Object)roleVisibility.getRoleLevelId());
        }

        public Option<Long> visit(GroupVisibility groupVisibility) {
            return Option.none();
        }

        public Option<Long> visit(InvalidVisibility invalidVisibility) {
            return Option.none();
        }
    };

    private VisibilityVisitors() {
    }

    public static VisibilityVisitor<Option<String>> returningGroupLevelVisitor() {
        return GROUP_LEVEL_VISITOR;
    }

    public static VisibilityVisitor<Option<Long>> returningRoleLevelIdVisitor() {
        return ROLE_LEVEL_VISITOR;
    }
}

