/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.project.version.remotelink;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.bc.project.version.remotelink.RemoteVersionLink;
import com.atlassian.jira.bc.project.version.remotelink.RemoteVersionLinkImpl;
import com.atlassian.jira.bc.project.version.remotelink.RemoteVersionLinkService;
import com.atlassian.jira.entity.property.EntityProperty;
import com.atlassian.jira.entity.property.EntityPropertyQuery;
import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.entity.property.FieldTooLongJsonPropertyException;
import com.atlassian.jira.entity.property.InvalidJsonPropertyException;
import com.atlassian.jira.entity.property.JsonEntityPropertyManager;
import com.atlassian.jira.entity.remotelink.AbstractRemoteEntityLinkService;
import com.atlassian.jira.event.project.RemoteVersionLinkDeleteEvent;
import com.atlassian.jira.event.project.RemoteVersionLinkPutEvent;
import com.atlassian.jira.event.project.VersionDeleteEvent;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@EventComponent
public class RemoteVersionLinkServiceImpl
extends AbstractRemoteEntityLinkService
implements RemoteVersionLinkService {
    public static final String REMOTE_VERSION_LINK = "RemoteVersionLink";
    static final String VERSION_ID = "versionId";
    static final String JSON = "json";
    private static final String MSG_VERSION_DOES_NOT_EXIST = "remotelink.service.version.does.not.exist";
    private static final String MSG_NO_LINK_VERSION_PERMISSION = "remotelink.service.no.link.version.permission";
    private final PermissionManager permissionManager;
    private final VersionManager versionManager;
    private final I18nHelper.BeanFactory i18nFactory;
    private final EventPublisher eventPublisher;

    public RemoteVersionLinkServiceImpl(JsonEntityPropertyManager jsonEntityPropertyManager, PermissionManager permissionManager, VersionManager versionManager, EventPublisher eventPublisher, I18nHelper.BeanFactory i18nFactory) {
        super(EntityPropertyType.REMOTE_VERSION_LINK.getDbEntityName(), jsonEntityPropertyManager);
        this.permissionManager = permissionManager;
        this.versionManager = versionManager;
        this.eventPublisher = eventPublisher;
        this.i18nFactory = i18nFactory;
    }

    public RemoteVersionLinkService.RemoteVersionLinkListResult getRemoteVersionLinksByVersionId(ApplicationUser user, Long versionId) {
        I18nHelper i18n = this.getI18nBean(user);
        SimpleErrorCollection errors = new SimpleErrorCollection();
        RemoteVersionLinkServiceImpl.verifyNotNull((ErrorCollection)errors, (I18nHelper)i18n, (String)VERSION_ID, (Object)versionId);
        if (errors.hasAnyErrors()) {
            return new RemoteVersionLinkService.RemoteVersionLinkListResult((ErrorCollection)errors);
        }
        Version version = this.versionManager.getVersion(versionId);
        if (!this.canView(user, version)) {
            errors.addError(VERSION_ID, i18n.getText(MSG_VERSION_DOES_NOT_EXIST, String.valueOf(versionId)), ErrorCollection.Reason.NOT_FOUND);
            return new RemoteVersionLinkService.RemoteVersionLinkListResult((ErrorCollection)errors);
        }
        List properties = ((EntityPropertyQuery.ExecutableQuery)this.jsonEntityPropertyManager.query().entityName(REMOTE_VERSION_LINK).entityId(versionId)).find();
        return new RemoteVersionLinkService.RemoteVersionLinkListResult(RemoteVersionLinkServiceImpl.toRemoteVersionLinks(properties, version));
    }

    public RemoteVersionLinkService.RemoteVersionLinkListResult getRemoteVersionLinksByGlobalId(ApplicationUser user, String globalId) {
        I18nHelper i18n = this.getI18nBean(user);
        SimpleErrorCollection errors = new SimpleErrorCollection();
        RemoteVersionLinkServiceImpl.verifyNotBlank((ErrorCollection)errors, (I18nHelper)i18n, (String)"globalId", (String)globalId);
        if (errors.hasAnyErrors()) {
            return new RemoteVersionLinkService.RemoteVersionLinkListResult((ErrorCollection)errors);
        }
        List properties = this.jsonEntityPropertyManager.query().entityName(REMOTE_VERSION_LINK).key(globalId).find();
        return new RemoteVersionLinkService.RemoteVersionLinkListResult(this.toAccessFilteredRemoteVersionLinks(properties, user));
    }

    public Long getRemoteVersionLinkCountByGlobalId(String globalId) {
        return this.jsonEntityPropertyManager.query().entityName(REMOTE_VERSION_LINK).key(globalId).count();
    }

    public RemoteVersionLinkService.RemoteVersionLinkResult getRemoteVersionLinkByVersionIdAndGlobalId(ApplicationUser user, Long versionId, String globalId) {
        I18nHelper i18n = this.getI18nBean(user);
        SimpleErrorCollection errors = new SimpleErrorCollection();
        RemoteVersionLinkServiceImpl.verifyNotNull((ErrorCollection)errors, (I18nHelper)i18n, (String)VERSION_ID, (Object)versionId);
        RemoteVersionLinkServiceImpl.verifyNotBlank((ErrorCollection)errors, (I18nHelper)i18n, (String)"globalId", (String)globalId);
        if (errors.hasAnyErrors()) {
            return new RemoteVersionLinkService.RemoteVersionLinkResult((ErrorCollection)errors);
        }
        Version version = this.versionManager.getVersion(versionId);
        if (!this.canView(user, version)) {
            errors.addError(VERSION_ID, i18n.getText(MSG_VERSION_DOES_NOT_EXIST, String.valueOf(versionId)), ErrorCollection.Reason.NOT_FOUND);
            return new RemoteVersionLinkService.RemoteVersionLinkResult((ErrorCollection)errors);
        }
        String json = this.getEntityPropertyValue(versionId, globalId);
        if (json == null) {
            errors.addErrorMessage(i18n.getText("remotelink.service.does.not.exist"), ErrorCollection.Reason.NOT_FOUND);
            return new RemoteVersionLinkService.RemoteVersionLinkResult((ErrorCollection)errors);
        }
        return new RemoteVersionLinkService.RemoteVersionLinkResult((RemoteVersionLink)new RemoteVersionLinkImpl(version, globalId, json));
    }

    public RemoteVersionLinkService.PutValidationResult validatePut(ApplicationUser user, Long versionId, String globalId, String json) {
        I18nHelper i18n = this.getI18nBean(user);
        SimpleErrorCollection errors = new SimpleErrorCollection();
        RemoteVersionLinkServiceImpl.verifyNotNull((ErrorCollection)errors, (I18nHelper)i18n, (String)VERSION_ID, (Object)versionId);
        RemoteVersionLinkServiceImpl.verifyNotBlank((ErrorCollection)errors, (I18nHelper)i18n, (String)JSON, (String)json);
        if (errors.hasAnyErrors()) {
            return new RemoteVersionLinkService.PutValidationResult((ErrorCollection)errors);
        }
        Version version = this.versionManager.getVersion(versionId);
        if (!this.canView(user, version)) {
            errors.addError(VERSION_ID, i18n.getText(MSG_VERSION_DOES_NOT_EXIST, String.valueOf(versionId)), ErrorCollection.Reason.VALIDATION_FAILED);
            return new RemoteVersionLinkService.PutValidationResult((ErrorCollection)errors);
        }
        if (!this.canEdit(user, version)) {
            String projectKey = version.getProjectObject().getKey();
            errors.addErrorMessage(i18n.getText(MSG_NO_LINK_VERSION_PERMISSION, projectKey), ErrorCollection.Reason.FORBIDDEN);
            return new RemoteVersionLinkService.PutValidationResult((ErrorCollection)errors);
        }
        if (StringUtils.isBlank((CharSequence)globalId)) {
            globalId = null;
        }
        try {
            String fixedGlobalId = this.putEntityPropertyDryRun(versionId, globalId, json);
            return new RemoteVersionLinkService.PutValidationResult(version, fixedGlobalId, json);
        }
        catch (FieldTooLongJsonPropertyException ftl) {
            errors.addError(ftl.getField(), i18n.getText("remotelink.service.field.too.long", ftl.getField(), String.valueOf(ftl.getMaximumLength())), ErrorCollection.Reason.VALIDATION_FAILED);
            return new RemoteVersionLinkService.PutValidationResult((ErrorCollection)errors);
        }
        catch (InvalidJsonPropertyException ijpe) {
            errors.addError(JSON, i18n.getText("remotelink.service.invalid.json", ijpe.toString()), ErrorCollection.Reason.VALIDATION_FAILED);
            return new RemoteVersionLinkService.PutValidationResult((ErrorCollection)errors);
        }
    }

    public RemoteVersionLinkService.RemoteVersionLinkResult put(ApplicationUser user, RemoteVersionLinkService.PutValidationResult putValidationResult) {
        Assertions.notNull((String)"putValidationResult", (Object)putValidationResult);
        if (!putValidationResult.isValid()) {
            throw new IllegalArgumentException("You cannot put using an invalid PutValidationResult");
        }
        try {
            Version version = putValidationResult.version;
            String json = putValidationResult.json;
            String globalId = this.putEntityPropertyValue(version.getId(), putValidationResult.globalId, json);
            this.eventPublisher.publish((Object)new RemoteVersionLinkPutEvent(version, globalId));
            return new RemoteVersionLinkService.RemoteVersionLinkResult((RemoteVersionLink)new RemoteVersionLinkImpl(version, globalId, json));
        }
        catch (RuntimeException re) {
            SimpleErrorCollection errors = new SimpleErrorCollection();
            errors.addErrorMessage(this.getI18nBean(user).getText("remotelink.service.error.creating", re.toString()), ErrorCollection.Reason.SERVER_ERROR);
            return new RemoteVersionLinkService.RemoteVersionLinkResult((ErrorCollection)errors);
        }
    }

    public RemoteVersionLinkService.DeleteValidationResult validateDelete(ApplicationUser user, Long versionId, String globalId) {
        I18nHelper i18n = this.getI18nBean(user);
        SimpleErrorCollection errors = new SimpleErrorCollection();
        RemoteVersionLinkServiceImpl.verifyNotNull((ErrorCollection)errors, (I18nHelper)i18n, (String)VERSION_ID, (Object)versionId);
        RemoteVersionLinkServiceImpl.verifyNotBlank((ErrorCollection)errors, (I18nHelper)i18n, (String)"globalId", (String)globalId);
        if (errors.hasAnyErrors()) {
            return new RemoteVersionLinkService.DeleteValidationResult((ErrorCollection)errors);
        }
        Version version = this.versionManager.getVersion(versionId);
        if (!this.canView(user, version)) {
            errors.addError(VERSION_ID, i18n.getText(MSG_VERSION_DOES_NOT_EXIST, String.valueOf(versionId)), ErrorCollection.Reason.VALIDATION_FAILED);
            return new RemoteVersionLinkService.DeleteValidationResult((ErrorCollection)errors);
        }
        if (!this.canEdit(user, version)) {
            String projectKey = version.getProjectObject().getKey();
            errors.addErrorMessage(i18n.getText(MSG_NO_LINK_VERSION_PERMISSION, projectKey), ErrorCollection.Reason.FORBIDDEN);
            return new RemoteVersionLinkService.DeleteValidationResult((ErrorCollection)errors);
        }
        if (!this.jsonEntityPropertyManager.exists(REMOTE_VERSION_LINK, versionId, globalId)) {
            errors.addErrorMessage(i18n.getText("remotelink.service.does.not.exist"), ErrorCollection.Reason.VALIDATION_FAILED);
            return new RemoteVersionLinkService.DeleteValidationResult((ErrorCollection)errors);
        }
        return new RemoteVersionLinkService.DeleteValidationResult(version, globalId);
    }

    public RemoteVersionLinkService.DeleteValidationResult validateDeleteByVersionId(ApplicationUser user, Long versionId) {
        I18nHelper i18n = this.getI18nBean(user);
        SimpleErrorCollection errors = new SimpleErrorCollection();
        RemoteVersionLinkServiceImpl.verifyNotNull((ErrorCollection)errors, (I18nHelper)i18n, (String)VERSION_ID, (Object)versionId);
        if (errors.hasAnyErrors()) {
            return new RemoteVersionLinkService.DeleteValidationResult((ErrorCollection)errors);
        }
        Version version = this.versionManager.getVersion(versionId);
        if (!this.canView(user, version)) {
            errors.addError(VERSION_ID, i18n.getText(MSG_VERSION_DOES_NOT_EXIST, String.valueOf(versionId)), ErrorCollection.Reason.VALIDATION_FAILED);
            return new RemoteVersionLinkService.DeleteValidationResult((ErrorCollection)errors);
        }
        if (!this.canEdit(user, version)) {
            String projectKey = version.getProjectObject().getKey();
            errors.addErrorMessage(i18n.getText(MSG_NO_LINK_VERSION_PERMISSION, projectKey), ErrorCollection.Reason.FORBIDDEN);
            return new RemoteVersionLinkService.DeleteValidationResult((ErrorCollection)errors);
        }
        if (this.jsonEntityPropertyManager.countByEntity(REMOTE_VERSION_LINK, versionId) == 0L) {
            errors.addErrorMessage(i18n.getText("remotelink.service.does.not.exist"), ErrorCollection.Reason.VALIDATION_FAILED);
            return new RemoteVersionLinkService.DeleteValidationResult((ErrorCollection)errors);
        }
        return new RemoteVersionLinkService.DeleteValidationResult(version, null);
    }

    public void delete(ApplicationUser user, RemoteVersionLinkService.DeleteValidationResult deleteValidationResult) {
        Assertions.notNull((String)"deleteValidationResult", (Object)deleteValidationResult);
        if (!deleteValidationResult.isValid()) {
            throw new IllegalArgumentException("You cannot delete using an invalid DeleteValidationResult");
        }
        if (deleteValidationResult.globalId != null) {
            this.jsonEntityPropertyManager.delete(REMOTE_VERSION_LINK, deleteValidationResult.versionId, deleteValidationResult.globalId);
        } else {
            this.jsonEntityPropertyManager.deleteByEntity(REMOTE_VERSION_LINK, deleteValidationResult.versionId);
        }
        this.eventPublisher.publish((Object)new RemoteVersionLinkDeleteEvent(deleteValidationResult.version, deleteValidationResult.globalId));
    }

    @EventListener
    public void onVersionDeleted(VersionDeleteEvent event) {
        this.jsonEntityPropertyManager.deleteByEntity(REMOTE_VERSION_LINK, Long.valueOf(event.getVersionId()));
    }

    I18nHelper getI18nBean(ApplicationUser user) {
        return this.i18nFactory.getInstance(user);
    }

    private boolean canView(ApplicationUser user, Version version) {
        return version != null && this.isProjectBrowser(user, version.getProjectObject());
    }

    private boolean canEdit(ApplicationUser user, Version version) {
        return version != null && this.isProjectAdmin(user, version.getProjectObject());
    }

    private boolean isProjectBrowser(ApplicationUser user, Project project) {
        return this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, project, user) || this.isProjectAdmin(user, project);
    }

    private boolean isProjectAdmin(ApplicationUser user, Project project) {
        return this.permissionManager.hasPermission(0, user) || this.permissionManager.hasPermission(ProjectPermissions.ADMINISTER_PROJECTS, project, user);
    }

    private static List<RemoteVersionLink> toRemoteVersionLinks(List<EntityProperty> list, final Version version) {
        return Lists.newArrayList((Iterable)Iterables.transform(list, (Function)new Function<EntityProperty, RemoteVersionLink>(){

            public RemoteVersionLink apply(EntityProperty property) {
                return new RemoteVersionLinkImpl(version, property.getKey(), property.getValue());
            }
        }));
    }

    List<RemoteVersionLink> toAccessFilteredRemoteVersionLinks(List<EntityProperty> properties, ApplicationUser user) {
        ArrayList<RemoteVersionLink> links = new ArrayList<RemoteVersionLink>(properties.size());
        VersionResolver versionResolver = new VersionResolver(user);
        for (EntityProperty property : properties) {
            Version version = versionResolver.apply(property.getEntityId());
            if (version == null) continue;
            links.add(new RemoteVersionLinkImpl(version, property.getKey(), property.getValue()));
        }
        return links;
    }

    class VersionResolver
    implements Function<Long, Version> {
        private final Map<Long, Boolean> projectAccessCache = new HashMap<Long, Boolean>();
        private final ApplicationUser user;

        VersionResolver(ApplicationUser user) {
            this.user = user;
        }

        public Version apply(Long versionId) {
            Version version = RemoteVersionLinkServiceImpl.this.versionManager.getVersion(versionId);
            if (version == null) {
                return null;
            }
            Long projectId = version.getProjectId();
            Boolean hasAccess = this.projectAccessCache.get(projectId);
            if (hasAccess == null) {
                hasAccess = RemoteVersionLinkServiceImpl.this.isProjectBrowser(this.user, version.getProjectObject());
                this.projectAccessCache.put(projectId, hasAccess);
            }
            return hasAccess != false ? version : null;
        }
    }
}

