/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bulkedit.operation;

import com.atlassian.jira.bulkedit.operation.BulkOperationException;
import com.atlassian.jira.bulkedit.operation.ProgressAwareBulkOperation;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.type.EventDispatchOption;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.bean.BulkEditBean;
import java.util.List;
import org.apache.log4j.Logger;

public class BulkDeleteOperation
implements ProgressAwareBulkOperation {
    protected static final Logger log = Logger.getLogger(BulkDeleteOperation.class);
    public static final String NAME = "BulkDelete";
    public static final String NAME_KEY = "bulk.delete.operation.name";
    private static final String DESCRIPTION_KEY = "bulk.delete.operation.description";
    private static final String CANNOT_PERFORM_MESSAGE_KEY = "bulk.delete.cannotperform";

    public boolean canPerform(BulkEditBean bulkEditBean, ApplicationUser remoteUser) {
        List selectedIssues = bulkEditBean.getSelectedIssues();
        PermissionManager permissionManager = ComponentAccessor.getPermissionManager();
        for (Issue issue : selectedIssues) {
            if (permissionManager.hasPermission(16, issue, remoteUser)) continue;
            return false;
        }
        return true;
    }

    public void perform(BulkEditBean bulkEditBean, ApplicationUser applicationUser, Context taskContext) throws BulkOperationException {
        List selectedIssues = bulkEditBean.getSelectedIssues();
        IssueManager issueManager = ComponentAccessor.getIssueManager();
        boolean sendMail = bulkEditBean.isSendBulkNotification();
        for (Issue issue : selectedIssues) {
            Context.Task task = taskContext.start((Object)issue);
            if (issueManager.getIssueObject(issue.getId()) != null) {
                try {
                    issueManager.deleteIssue(applicationUser, issue, EventDispatchOption.ISSUE_DELETED, sendMail);
                }
                catch (RemoveException e) {
                    throw new BulkOperationException((Throwable)e);
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Not deleting issue with id '" + issue.getId() + "' and key '" + issue.getKey() + "' as it does not exist in the database (it could have been deleted earlier as it might be a subtask)."));
            }
            task.complete();
        }
    }

    public int getNumberOfTasks(BulkEditBean bulkEditBean) {
        return bulkEditBean.getSelectedIssues().size();
    }

    public String getNameKey() {
        return NAME_KEY;
    }

    public String getDescriptionKey() {
        return DESCRIPTION_KEY;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof BulkDeleteOperation;
    }

    public String getOperationName() {
        return NAME;
    }

    public String getCannotPerformMessageKey() {
        return CANNOT_PERFORM_MESSAGE_KEY;
    }
}

