/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config;

import com.atlassian.jira.config.IssueTypePermissionService;
import com.atlassian.jira.config.IssueTypeService;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import javax.annotation.Nullable;

public class DefaultIssueTypePermissionService
implements IssueTypePermissionService {
    private final IssueTypeService issueTypeService;
    private final GlobalPermissionManager globalPermissionManager;

    public DefaultIssueTypePermissionService(IssueTypeService issueTypeService, GlobalPermissionManager globalPermissionManager) {
        this.issueTypeService = issueTypeService;
        this.globalPermissionManager = globalPermissionManager;
    }

    public boolean hasPermissionToViewIssueType(ApplicationUser user, String id) {
        return this.issueTypeService.getIssueType(user, id).isDefined();
    }

    public boolean hasPermissionToEditIssueType(@Nullable ApplicationUser user) {
        return this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user);
    }
}

