/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.database;

import com.atlassian.jira.config.database.DatabaseConfig;
import com.google.common.collect.Iterables;
import com.mysema.query.BooleanBuilder;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.expr.SimpleExpression;
import java.util.Collection;
import java.util.List;

public class SqlPredicates {
    public static final int MAX_SQL_SERVER_PARAMETER_LIMIT = 2000;
    private DatabaseConfig dbConfig;
    private static final int MAX_LIST_SIZE_ORACLE = 1000;

    public SqlPredicates(DatabaseConfig dbConfig) {
        this.dbConfig = dbConfig;
    }

    public <D> Predicate partitionedIn(SimpleExpression<D> left, Collection<? extends D> right) {
        if (this.dbConfig.isOracle() && right.size() > 1000) {
            Iterable partitioned = Iterables.partition(right, (int)1000);
            return this.inAny(left, partitioned);
        }
        return left.in(right);
    }

    public <D> Predicate inAny(SimpleExpression<D> left, Iterable<? extends List<? extends D>> lists) {
        BooleanBuilder builder = new BooleanBuilder();
        lists.forEach(list -> builder.or((Predicate)left.in((Collection)list)));
        return builder;
    }
}

