/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.datetime;

import com.atlassian.jira.datetime.DateTimeFormatStrategy;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.datetime.JodaFormatterSupplier;
import java.util.Date;
import java.util.Locale;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;

class DateTimeISO8601DateTimeFormatter
implements DateTimeFormatStrategy {
    public static String ISO8601_LOCAL_TIME = "yyyy-MM-dd'T'HH:mm:ssZ";
    public static String ISO8601_UTC = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private final JodaFormatterSupplier cache;

    public DateTimeISO8601DateTimeFormatter(JodaFormatterSupplier cache) {
        this.cache = cache;
    }

    @Override
    public String format(DateTime dateTime, Locale locale) {
        DateTimeFormatter formatter = this.cache.get(new JodaFormatterSupplier.Key(ISO8601_LOCAL_TIME, Locale.US));
        return formatter.print((ReadableInstant)dateTime);
    }

    @Override
    public Date parse(String text, DateTimeZone timeZone, Locale locale) {
        try {
            DateTimeFormatter formatter = this.cache.get(new JodaFormatterSupplier.Key(ISO8601_LOCAL_TIME, Locale.US)).withZone(timeZone);
            return formatter.parseDateTime(text).toDate();
        }
        catch (IllegalArgumentException e) {
            DateTimeFormatter formatter = this.cache.get(new JodaFormatterSupplier.Key(ISO8601_UTC, Locale.US)).withZone(DateTimeZone.UTC);
            return formatter.parseDateTime(text).toDate();
        }
    }

    @Override
    public DateTimeStyle style() {
        return DateTimeStyle.ISO_8601_DATE_TIME;
    }

    @Override
    public String pattern() {
        return ISO8601_LOCAL_TIME;
    }
}

