/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.entity;

import com.google.common.base.Function;
import org.ofbiz.core.entity.GenericValue;

public class GenericValueFunctions {
    public static GetLongFunction getLong(String field) {
        return new GetLongFunction(field);
    }

    public static GetStringAsLongFunction getStringAsLong(String field) {
        return new GetStringAsLongFunction(field);
    }

    public static GetStringFunction getString(String field) {
        return new GetStringFunction(field);
    }

    public static class GetStringFunction
    implements Function<GenericValue, String>,
    com.atlassian.jira.util.Function<GenericValue, String> {
        private final String field;

        public GetStringFunction(String field) {
            this.field = field;
        }

        public String apply(GenericValue input) {
            return input.getString(this.field);
        }

        public String get(GenericValue input) {
            return this.apply(input);
        }
    }

    public static class GetStringAsLongFunction
    implements Function<GenericValue, Long>,
    com.atlassian.jira.util.Function<GenericValue, Long> {
        private final String field;

        public GetStringAsLongFunction(String field) {
            this.field = field;
        }

        public Long apply(GenericValue input) {
            return Long.valueOf(input.getString(this.field));
        }

        public Long get(GenericValue input) {
            return this.apply(input);
        }
    }

    public static class GetLongFunction
    implements Function<GenericValue, Long>,
    com.atlassian.jira.util.Function<GenericValue, Long> {
        private final String field;

        public GetLongFunction(String field) {
            this.field = field;
        }

        public Long apply(GenericValue input) {
            return input.getLong(this.field);
        }

        public Long get(GenericValue input) {
            return this.apply(input);
        }
    }
}

