/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.entity;

import com.atlassian.jira.entity.PagedListIterator;
import com.atlassian.jira.util.collect.PagedList;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;

public class PredicatedPagedList<E>
implements PagedList<E> {
    final Predicate<E> predicate;
    final PagedList<E> delegate;

    public PredicatedPagedList(PagedList<E> delegate, Predicate<E> predicate) {
        this.predicate = predicate;
        this.delegate = delegate;
    }

    public List<E> getPage(int pageNumber) {
        List unfilteredList = this.delegate.getPage(pageNumber);
        return Lists.newArrayList((Iterable)Iterables.filter((Iterable)unfilteredList, this.predicate));
    }

    public Iterator<List<E>> iterator() {
        return new PagedListIterator(this);
    }

    public List<E> getCompleteList() {
        List unfilteredList = this.delegate.getCompleteList();
        return Lists.newArrayList((Iterable)Iterables.filter((Iterable)unfilteredList, this.predicate));
    }

    public int getSize() {
        return this.delegate.getSize();
    }

    public int getPageSize() {
        return this.delegate.getPageSize();
    }
}

