/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.entity.property;

import com.atlassian.jira.entity.WithId;
import com.atlassian.jira.entity.property.EntityPropertyOptions;
import com.atlassian.jira.entity.property.EntityPropertyService;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

public class DelegatingEntityPropertyService<E extends WithId>
implements EntityPropertyService<E> {
    private final EntityPropertyService<E> delegate;

    public DelegatingEntityPropertyService(EntityPropertyService<E> delegate) {
        this.delegate = (EntityPropertyService)Preconditions.checkNotNull(delegate);
    }

    public ErrorCollection validatePropertyInput(EntityPropertyService.PropertyInput propertyInput) {
        return this.delegate.validatePropertyInput(propertyInput);
    }

    public EntityPropertyService.SetPropertyValidationResult validateSetProperty(ApplicationUser user, @Nonnull Long entityId, @Nonnull EntityPropertyService.PropertyInput propertyInput) {
        return this.delegate.validateSetProperty(user, entityId, propertyInput);
    }

    public EntityPropertyService.SetPropertyValidationResult validateSetProperty(ApplicationUser user, @Nonnull Long entityId, @Nonnull EntityPropertyService.PropertyInput propertyInput, @Nonnull EntityPropertyOptions options) {
        return this.delegate.validateSetProperty(user, entityId, propertyInput, options);
    }

    public EntityPropertyService.PropertyResult setProperty(ApplicationUser user, @Nonnull EntityPropertyService.SetPropertyValidationResult propertyValidationResult) {
        return this.delegate.setProperty(user, propertyValidationResult);
    }

    public EntityPropertyService.DeletePropertyValidationResult validateDeleteProperty(ApplicationUser user, @Nonnull Long entityId, @Nonnull String propertyKey) {
        return this.delegate.validateDeleteProperty(user, entityId, propertyKey);
    }

    public EntityPropertyService.DeletePropertyValidationResult validateDeleteProperty(ApplicationUser user, @Nonnull Long entityId, @Nonnull String propertyKey, @Nonnull EntityPropertyOptions options) {
        return this.delegate.validateDeleteProperty(user, entityId, propertyKey, options);
    }

    public void deleteProperty(ApplicationUser user, @Nonnull EntityPropertyService.DeletePropertyValidationResult validationResult) {
        this.delegate.deleteProperty(user, validationResult);
    }

    public EntityPropertyService.PropertyResult getProperty(ApplicationUser user, @Nonnull Long entityId, @Nonnull String propertyKey) {
        return this.delegate.getProperty(user, entityId, propertyKey);
    }

    public EntityPropertyService.PropertyResult getProperty(ApplicationUser user, @Nonnull Long entityId, @Nonnull String propertyKey, @Nonnull EntityPropertyOptions options) {
        return this.delegate.getProperty(user, entityId, propertyKey, options);
    }

    public EntityPropertyService.PropertyKeys<E> getPropertiesKeys(ApplicationUser user, @Nonnull Long entityId) {
        return this.delegate.getPropertiesKeys(user, entityId);
    }

    public EntityPropertyService.PropertyKeys<E> getPropertiesKeys(ApplicationUser user, @Nonnull Long entityId, @Nonnull EntityPropertyOptions options) {
        return this.delegate.getPropertiesKeys(user, entityId, options);
    }
}

